<?php
/*
 * This file is part of HELIOS.PetitMail
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Heliosメール履歴　画面インターフェース
 *
 * @copyright 2008- EXBRIDGE,Inc. All Rights Reserved.
 * @link      http://exbridge.jp/
 * @package   HELIOS.PetitMail
 * @version   svn:$Id: iMailHistoryController.php 8524 2008-09-27 08:27:02Z shimizu $
 */
class iMailHistoryController extends xbeHeliosPetitMailController {

    var $_display_name  = T_MAIL_HISTORY; //画面名

    /**
     * 初期処理
     *
     * コントローラー初期処理
     *
     */
    function init(){
    }

    /**
     * デフォルト呼出
     */
    function executeDefault() {
        $this->forward('Show');
    }

    /**
     * 検索
     */
    function executeRequestSearch() {
        $search_params['send_date_from']    = $this->send_date_from_yyyy . $this->send_date_from_mm . $this->send_date_from_dd;
        $search_params['send_date_to']      = $this->send_date_to_yyyy . $this->send_date_to_mm . $this->send_date_to_dd;
        $search_params['subject']           = $this->subject;
        $search_params['body']              = $this->body;
        $search_params['status_kb_list']    = $this->status_kb_list;
        $search_params['to_mail']           = $this->to_mail;

        $this->search_params = $search_params;
        $this->forward('Show');
    }

    /**
     * 画面表示
     */
    function executeShow() {
        $url = HELIOS_PETITMAIL_URL . 'web.php?action=RequestSendMailHistoryList';
        $data = get_url_contents($url, $this->search_params);
        $this->send_mail_history_list = json_decode($data, true);
        $this->render('interface/mail_history');
    }
}
