use 5.008004;
use ExtUtils::MakeMaker;

#
# Get path to dokan library
#
use Getopt::Long;
my $dokan_library = "C:/Program Files/Dokan/DokanLibrary";
GetOptions("l|dokan-library=s" => \$dokan_library);

unless (-f "$dokan_library/dokan.h") {
    $dokan_library = "." if (-f "./dokan.h");
}
-f "$dokan_library/dokan.h" or die "$dokan_library/dokan.h: $!\nSpecify path to library using -l option like this:\n perl Makefile -l \"Z:\\Dokan\\DokanLibrary\"\n";

#
# check Dokan.dll
#
my $dll_found;
{
    my @path = split(';', $ENV{PATH});
    unshift(@path, "$ENV{windir}\\System32");

    for my $p (@path) {
	my $dll_path = "$p\\Dokan.dll";
	if (-f $dll_path) {
	    $dll_found = 1;
	    last;
	}
    }
}
$dll_found or die "Dokan.dll not found. Dokan library installed?";

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'Win32::Dokan',
    VERSION_FROM      => 'lib/Win32/Dokan.pm', # finds $VERSION
    PREREQ_PM         => { Class::Accessor }, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/Win32/Dokan.pm', # retrieve abstract from module
       AUTHOR         => 'Toshimitsu FUJIWARA <tttfjw at gmail.com>') : ()),
    LIBS              => [''], # e.g., '-lm'
    DEFINE            => '', # e.g., '-DHAVE_SOMETHING'
    INC               => "-I. -I\"$dokan_library\"", # e.g., '-I. -I/usr/include/other'
    clean             => {'FILES' => '*.inc *.ppd dokan.h'},
	# Un-comment this if you add C files to link with later:
    # OBJECT            => '$(O_FILES)', # link all the C files too
);
if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (qw(DOKAN_DRIVER_INSTALL_ERROR
		  DOKAN_DRIVE_LETTER_ERROR DOKAN_ERROR DOKAN_MOUNT_ERROR
		  DOKAN_START_ERROR DOKAN_SUCCESS
		  FILE_ATTRIBUTE_READONLY
		  FILE_ATTRIBUTE_HIDDEN
		  FILE_ATTRIBUTE_SYSTEM
		  FILE_ATTRIBUTE_DIRECTORY
		  FILE_ATTRIBUTE_ARCHIVE
		  FILE_ATTRIBUTE_DEVICE
		  FILE_ATTRIBUTE_NORMAL
		  FILE_ATTRIBUTE_TEMPORARY
		  FILE_ATTRIBUTE_SPARSE_FILE
		  FILE_ATTRIBUTE_REPARSE_POINT
		  FILE_ATTRIBUTE_COMPRESSED
		  FILE_ATTRIBUTE_OFFLINE
		  FILE_ATTRIBUTE_NOT_CONTENT_INDEXED
		  FS_CASE_IS_PRESERVED
		  FS_CASE_SENSITIVE
		  FS_UNICODE_STORED_ON_DISK
		  FS_PERSISTENT_ACLS
		  FS_FILE_COMPRESSION
		  FS_VOL_IS_COMPRESSED
		  FILE_NAMED_STREAMS
		  FILE_SUPPORTS_ENCRYPTION
		  FILE_SUPPORTS_OBJECT_IDS
		  FILE_SUPPORTS_REPARSE_POINTS
		  FILE_SUPPORTS_SPARSE_FILES
		  FILE_VOLUME_QUOTAS

		  CREATE_NEW
		  CREATE_ALWAYS
		  OPEN_EXISTING
		  OPEN_ALWAYS
		  TRUNCATE_EXISTING

		  GENERIC_READ
		  GENERIC_WRITE
		  GENERIC_EXECUTE

		  FILE_SHARE_READ
		  FILE_SHARE_WRITE
		  FILE_SHARE_DELETE

		  ERROR_INVALID_FUNCTION
		  ERROR_FILE_NOT_FOUND
		  ERROR_PATH_NOT_FOUND
		  ERROR_TOO_MANY_OPENFILES
		  ERROR_ACCESS_DENIED
		  ERROR_INVALID_BLOCK
		  ERROR_INVALID_ACCESS
		  ERROR_WRITE_PROTECT
		  ERROR_NOT_READY
		  ERROR_SEEK
		  ERROR_WRITE_FAULT
		  ERROR_READ_FAULT
		  ERROR_GEN_FAILURE
		  ERROR_LOCK_VIOLATION
		  ERROR_NOT_SUPPORTED
		  ERROR_DISK_FULL
		  ERROR_DIR_NOT_EMPTY
		  ERROR_PATH_BUSY
		  ERROR_ALREADY_EXISTS
		  ERROR_FILE_EXISTS
		  ERROR_DRIVE_LOKED
		  ERROR_NOT_LOCKED
		  ERROR_LOCK_FAILED
		  ERROR_LOCKED
));

  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'Win32::Dokan::Const',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}

#
# fix for VC90
#
use Config;

if ($Config{cc} eq 'cl' && $Config{libpth} =~ /VC98/
    && defined($ENV{VS90COMNTOOLS})) {
  print "VC90 is found. fixing Makefile...\n";
  do 'buildtools/fix-makefile-vc90.pl';
  print "done.\n";
}
