#
# WIN32_FIND_DATAW
#
package Win32::Dokan::FindDataW;

use base qw(Class::Accessor);

__PACKAGE__->mk_accessors(qw(file_attributes
			     creation_time
			     last_access_time
			     last_write_time
			     file_size
			     number_of_links
			     file_name
			     alternative_file_name));

use vars qw($Unicode_func);

sub unicode_file_name {
    my $self = shift;
    my $value = $self->file_name;

    if ($Unicode_func && defined($value)) {
	return &$Unicode_func($value);
    }

    return $value;
}

sub unicode_alternative_name {
    my $self = shift;
    my $value = $self->alternative_file_name;

    if ($Unicode_func && defined($value)) {
	return &$Unicode_func($value);
    }

    return $value;
}

1;
