/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.satogaeri;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaBase;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator2;
import pencilbox.satogaeri.Area;
import pencilbox.satogaeri.Board;

public class BoardCopier
extends BoardCopierBase {
    @Override
    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, AreaBase region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        ArrayList<Area> srcAreaList = new ArrayList<Area>();
        block0: for (Address s : region) {
            Address dd;
            Area srcArea = srcBoard.getArea(s);
            if (srcArea == null || srcAreaList.contains(srcArea)) continue;
            srcAreaList.add(srcArea);
            if (!region.containsAll(srcArea)) continue;
            Area dstArea = new Area();
            for (Address ss : srcArea) {
                dd = this.translateAndRotateAddress(ss, from, to, rotation);
                if (!board.isOn(dd)) continue block0;
            }
            for (Address ss : srcArea) {
                dd = this.translateAndRotateAddress(ss, from, to, rotation);
                if (!board.isOn(dd)) continue;
                Area oldArea = board.getArea(dd);
                if (oldArea != null) {
                    board.removeWholeArea(oldArea);
                }
                board.addCellToArea(dd, dstArea);
            }
        }
        for (Address s : region) {
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            board.changeFixedNumber(d, srcBoard.getNumber(s));
        }
        block4: for (Address s : region) {
            Address dd;
            if (!srcBoard.hasNumber(s)) continue;
            ArrayList<Address> routeArea = srcBoard.getCellsOfWholeRoute(s);
            for (Address ss : routeArea) {
                if (!region.contains(ss)) continue block4;
            }
            for (Address ss : routeArea) {
                dd = this.translateAndRotateAddress(ss, from, to, rotation);
                if (!board.isOn(dd)) continue block4;
            }
            for (Address ss : routeArea) {
                dd = this.translateAndRotateAddress(ss, from, to, rotation);
                int st = srcBoard.getRoute(ss);
                if (st >= 0 && st <= 3) {
                    st = Rotator2.rotateDirection(st, rotation);
                }
                board.changeRoute(dd, st);
            }
        }
    }

    @Override
    public void eraseRegion(BoardBase boardBase, AreaBase region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            if (!board.hasNumber(s)) continue;
            board.eraseRoute(s);
        }
        for (Address s : region) {
            board.changeFixedNumber(s, -1);
        }
        for (Address s : region) {
            Area srcArea = board.getArea(s);
            if (srcArea == null || !region.containsAll(srcArea)) continue;
            board.removeWholeArea(srcArea);
        }
    }
}

