/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.sudoku.Board;
import pencilbox.sudoku.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(this.board.rows());
    }

    private void setSelectedNumber(int n) {
        ((Panel)this.getPanel()).setSelectedNumber(n);
    }

    @Override
    protected void leftPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos))) {
            int n = this.board.getState(pos);
            if (n >= this.getMaxInputNumber()) {
                this.board.changeAnswerNumber(pos, 0);
            } else if (n >= 0) {
                this.board.changeAnswerNumber(pos, n + 1);
            }
        }
        this.setSelectedNumber(this.board.getNumberOrState(pos));
    }

    @Override
    protected void rightPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos))) {
            int n = this.board.getState(pos);
            if (n == 0) {
                this.board.changeAnswerNumber(pos, this.getMaxInputNumber());
            } else if (n > 0) {
                this.board.changeAnswerNumber(pos, n - 1);
            }
        }
        this.setSelectedNumber(this.board.getNumberOrState(pos));
    }

    @Override
    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                Address posS;
                this.board.changeFixedNumber(pos, num);
                if (this.isSymmetricPlacementMode() && !this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                    this.board.changeFixedNumber(posS, -2);
                }
            }
        } else if (this.isCursorOn() && num >= 0 && !this.board.isStable(pos)) {
            this.board.changeAnswerNumber(pos, num);
        }
    }

    @Override
    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeFixedNumber(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.changeFixedNumber(posS, 0);
            }
        } else if (this.isCursorOn() && !this.board.isStable(pos)) {
            this.board.changeAnswerNumber(pos, 0);
        }
    }

    @Override
    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeFixedNumber(pos, -2);
            if (this.isSymmetricPlacementMode() && !this.board.isStable(posS = this.getSymmetricPosition(pos))) {
                this.board.changeFixedNumber(posS, -2);
            }
        }
    }
}

