/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import pencilbox.common.core.BoardBase;
import pencilbox.common.io.XmlWriterBase;
import pencilbox.nurikabe.Board;

public class XmlWriter
extends XmlWriterBase {
    @Override
    protected void setBoardData(BoardBase theboard) {
        Board board = (Board)theboard;
        int rows = board.rows();
        int cols = board.cols();
        int r = 0;
        while (r < rows) {
            int c = 0;
            while (c < cols) {
                int n = board.getState(r, c);
                if (n > 0 || n == -3) {
                    // empty if block
                }
                this.outNumber(r, c, n);
                ++c;
            }
            ++r;
        }
    }

    @Override
    protected void setAnswerData(BoardBase theboard) {
        Board board = (Board)theboard;
        int rows = board.rows();
        int cols = board.cols();
        int r = 0;
        while (r < rows) {
            this.startArow(r);
            int c = 0;
            while (c < cols) {
                int st = board.getState(r, c);
                if (st == -2) {
                    this.out("w");
                } else if (st == -1) {
                    this.out("s");
                } else {
                    this.out("u");
                }
                ++c;
            }
            this.endArow();
            ++r;
        }
    }
}

