/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.common.core.Address;

public class Word {
    private Address head;
    private int size;
    private int sum;
    private int filledSize;
    private int filledSum;

    int getSize() {
        return this.size;
    }

    int getSum() {
        return this.sum;
    }

    Address getHead() {
        return this.head;
    }

    public Word(Address p, int count, int number) {
        this.head = p;
        this.size = count;
        this.sum = number;
    }

    public void clear() {
        this.filledSize = 0;
        this.filledSum = 0;
    }

    public void changeNumber(int before, int after) {
        if (before == 0) {
            if (after > 0) {
                ++this.filledSize;
                this.filledSum += after;
            }
        } else if (before > 0) {
            if (after == 0) {
                --this.filledSize;
                this.filledSum -= before;
            } else if (after > 0) {
                this.filledSum = this.filledSum - before + after;
            }
        }
    }

    public int getStatus() {
        int status = 0;
        status = this.filledSize < this.size ? 0 : (this.filledSum == this.sum ? 1 : -1);
        return status;
    }

    public int extractSum() {
        if (this.filledSize == this.size) {
            return this.filledSum;
        }
        return 0;
    }
}

