/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.kakuro.Board;
import pencilbox.kakuro.KakuroCursor;

public class Panel
extends PanelBase {
    private Board board;
    private Font smallFont = new Font("SansSerif", 0, 13);
    private HintDot hintDot = new HintDot();

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setWallColor(new Color(0xC0C0C0));
        this.setCursorMode(true);
    }

    @Override
    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.hintDot.setDot(this, 3, this.getCellSize());
    }

    @Override
    public void setDisplaySize(int size) {
        super.setDisplaySize(size);
        this.smallFont = new Font("SansSerif", 0, this.getCellSize() / 2);
        this.hintDot.setDotSize(this.getCellSize());
    }

    @Override
    public CellCursor createCursor() {
        return new KakuroCursor();
    }

    @Override
    public void drawBoard(Graphics2D g) {
        this.drawWalls(g);
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawWalls(Graphics2D g) {
        g.setFont(this.smallFont);
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            if (this.board.isWall(p)) {
                this.drawWall(g, p, this.board.getSumH(p), this.board.getSumV(p));
            }
            ++n2;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        Address[] addressArray = this.board.cellAddrs();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address p = addressArray[n2];
            int number = this.board.getNumber(p);
            if (number > 0) {
                g.setColor(this.getInputColor());
                if (this.isIndicateErrorMode() && this.board.isMultipleNumber(p)) {
                    g.setColor(this.getErrorColor());
                }
                this.placeNumber(g, p, number);
            } else if (number == 0 && this.isDotHintMode()) {
                this.placeHintDot(g, p);
            }
            ++n2;
        }
    }

    void drawWall(Graphics2D g, Address p, int a, int b) {
        g.setColor(this.getWallColor());
        this.paintCell(g, p);
        g.setColor(this.getGridColor());
        this.edgeCell(g, p);
        g.drawLine(this.toX(p), this.toY(p), this.toX(p) + this.getCellSize(), this.toY(p) + this.getCellSize());
        if (b > 0) {
            g.setColor(this.getNumberColor());
            if (this.isIndicateErrorMode() && this.board.getWordStatus(p, 0) == -1) {
                g.setColor(this.getErrorColor());
            }
            this.drawString(g, this.toX(p) + this.getHalfCellSize() / 2 + 1, this.toY(p) + this.getCellSize() - this.getHalfCellSize() / 2, Integer.toString(b));
        }
        if (a > 0) {
            g.setColor(this.getNumberColor());
            if (this.isIndicateErrorMode() && this.board.getWordStatus(p, 1) == -1) {
                g.setColor(this.getErrorColor());
            }
            this.drawString(g, this.toX(p) + this.getCellSize() - this.getHalfCellSize() / 2, this.toY(p) + this.getHalfCellSize() / 2 + 1, Integer.toString(a));
        }
    }

    @Override
    public void drawCursor(Graphics2D g) {
        super.drawCursor(g);
        if (this.isProblemEditMode()) {
            KakuroCursor kcursor = (KakuroCursor)this.getCellCursor();
            g.drawRect(this.toX(kcursor.c()) + kcursor.getStair() * this.getHalfCellSize(), this.toY(kcursor.r()) + (kcursor.getStair() ^ 1) * this.getHalfCellSize(), this.getHalfCellSize(), this.getHalfCellSize());
        }
    }

    void placeHintDot(Graphics2D g, Address p) {
        int pattern = this.board.getPattern(p);
        if (pattern == 0) {
            this.hintDot.placeHintCross(g, p);
        } else {
            this.hintDot.placeHintDot(g, p, pattern);
        }
    }
}

