/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PencilBoxDialog;
import pencilbox.resource.Messages;

public class ExchangeNumbersDialog
extends PencilBoxDialog {
    private static ExchangeNumbersDialog instance = new ExchangeNumbersDialog();
    private JPanel mainPanel;
    private JSpinner[] spinner;
    private SpinnerModel[] spinnerModel;
    private JButton buttonUpdate;
    private BoardBase board;
    private PanelBase panel;

    public static ExchangeNumbersDialog getInstance() {
        return instance;
    }

    private ExchangeNumbersDialog() {
    }

    @Override
    protected void makeDialog() {
        this.setDialogType(0);
        super.makeDialog();
        this.makeMainPanel();
    }

    private void makeMainPanel() {
        this.mainPanel = new JPanel(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.spinner = new JSpinner[2];
        this.spinnerModel = new SpinnerModel[2];
        int i = 0;
        while (i < 2) {
            this.spinner[i] = new JSpinner();
            this.spinnerModel[i] = new SpinnerNumberModel(1, 1, 99, 1);
            this.spinner[i].setModel(this.spinnerModel[i]);
            ++i;
        }
        JLabel label1 = new JLabel(Messages.getString("ExchangeNumbersDialog.label1"));
        JLabel label2 = new JLabel(Messages.getString("ExchangeNumbersDialog.label2"));
        this.buttonUpdate = new JButton(Messages.getString("ExchangeNumbersDialog.buttonUpdate"));
        this.buttonUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int v0 = ((Number)ExchangeNumbersDialog.this.spinner[0].getValue()).intValue();
                int v1 = ((Number)ExchangeNumbersDialog.this.spinner[1].getValue()).intValue();
                ExchangeNumbersDialog.this.board.exchangeNumbers(v0, v1);
                ExchangeNumbersDialog.this.panel.repaint();
            }
        });
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets.top = 2;
        constraints.insets.bottom = 2;
        constraints.insets.left = 0;
        constraints.insets.right = 0;
        constraints.fill = 1;
        this.addComponent(label1, constraints, 0, 0, 1, 1);
        this.addComponent(this.spinner[0], constraints, 1, 0, 1, 1);
        this.addComponent(label2, constraints, 0, 1, 1, 1);
        this.addComponent(this.spinner[1], constraints, 1, 1, 1, 1);
        this.addComponent(this.buttonUpdate, constraints, 1, 2, 1, 1);
        this.add((Component)this.mainPanel, "Center");
    }

    private void addComponent(Component c, GridBagConstraints constraints, int x, int y, int w, int h) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = w;
        constraints.gridheight = h;
        this.mainPanel.add(c, constraints);
    }

    public void setup(BoardBase b, PanelBase p) {
        this.board = b;
        this.panel = p;
    }

    public void setRange(int min, int max) {
        int i = 0;
        while (i < 2) {
            SpinnerNumberModel model = (SpinnerNumberModel)this.spinnerModel[i];
            model.setMinimum(Integer.valueOf(min));
            model.setMaximum(Integer.valueOf(max));
            int v = model.getNumber().intValue();
            if (v < min || v > max) {
                model.setValue(min);
            }
            ++i;
        }
    }
}

