package pencilbox.hakyukoka;

import java.util.LinkedList;
import java.util.List;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.AreaEditStep;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.common.core.AbstractStep.EditType;
import pencilbox.resource.Messages;


/**
 * ugyʁvՖʃNX
 * qg@\
 */
public class Board extends BoardBase {
	
	static final int BLANK = 0;
	static final int UNKNOWN = 0;
	static final int UNDETERMINED = -2;
	
	private List<Area> areaList;
//	private int maxNumber = 9; // ő吔9Ƃ
	private int[][] state; // 𓚂̐
	private int[][] number; // ̐
	private Area[][] area;

	private int[][] multi;  // sł̏dL^
	private int[][] multi2;  // ̈ł̏dL^
	private DigitPatternHint hint;       // gp\p^[

	protected void setup() {
		super.setup();
		state = new int[rows()][cols()];
		number = new int[rows()][cols()];
		area = new Area[rows()][cols()];
		areaList = new LinkedList<Area>();
		multi = new int[rows()][cols()];
		multi2 = new int[rows()][cols()];
		hint = new DigitPatternHint();
		hint.setupHint(this);
	}

	public void clearBoard() {
		for (Address p : cellAddrs()) {
			setState(p, 0);
		}
		initBoard();
	}
	/**
	 * ̃}X͖ƂĐ^ꂽ}Xǂ
	 * @param r }X̍sW
	 * @param c }X̗W
	 * @return 萔̃}XȂ true, 𓚂ׂ}XȂ false
	 */
	public boolean isStable(int r, int c) {
		return number[r][c] != Board.BLANK;
	}

	public boolean isStable(Address pos) {
		return isStable(pos.r(), pos.c());
	}
	/**
	 * Get state of a cell.
	 * @param r Row coordinate of the cell.
	 * @param c Column coordinate of the cell.
	 * @return Returns the state.
	 */
	public int getState(int r, int c) {
		return state[r][c];
	}

	public int getState(Address pos) {
		return getState(pos.r(), pos.c());
	}
	/**
	 * Set state to a cell.
	 * @param r Row coordinate of the cell.
	 * @param c Column coordinate of the cell.
	 * @param st The state to set.
	 */
	public void setState(int r, int c, int st) {
		state[r][c] = st;
	}

	public void setState(Address pos, int st) {
		setState(pos.r(), pos.c(), st);
	}
	/**
	 * Get number of a cell.
	 * @param r Row coordinate of the cell.
	 * @param c Column coordinate of the cell.
	 * @return Returns the number.
	 */
	public int getNumber(int r, int c) {
		return number[r][c];
	}

	public int getNumber(Address pos) {
		return getNumber(pos.r(), pos.c());
	}
	/**
	 * Set number to  a cell.
	 * @param r Row coordinate of the cell.
	 * @param c Column coordinate of the cell.
	 * @param n The number to set.
	 */
	public void setNumber(int r, int c, int n) {
		number[r][c] = n;
	}
	
	public void setNumber(Address pos, int n) {
		setNumber(pos.r(), pos.c(), n);
	}

	public int getNumberOrState(Address p) {
		return isStable(p) ? getNumber(p) : getState(p);
	}
	/**
	 * ̃}X̏̈擾
	 * ̃}ẌɑĂȂꍇ null Ԃ
	 * @param r Row coordinate of the cell.
	 * @param c Column coordinate of the cell.
	 * @return Returns the area.
	 */
	public Area getArea(int r, int c) {
		return area[r][c];
	}
	
	public Area getArea(Address pos) {
		return getArea(pos.r(), pos.c());
	}
	/**
	 * Տ̃}XɁC̃}X̏̈ݒ肷
	 * @param r Row coordinate of the cell.
	 * @param c Column coordinate of the cell.
	 * @param a The area to set.
	 */
	public void setArea(int r, int c, Area a) {
		area[r][c] = a;
	}

	public void setArea(Address pos, Area a) {
		setArea(pos.r(), pos.c(), a);
	}
	/**
	 * zȕꍇ true Ԃ
	 * ̐̋ȓɓ邩C
	 * ̈ɓ邩C
	 * ̈̃}X傫ł΁CtrueԂ
	 * @param p }X̍W
	 * @return ̃}X̐ł true Ԃ
	 */
	public boolean isError(Address p) {
		return isTooClose(p) || isMultipleNumber(p) || isTooLarge(p);
	}
	/**
	 * ̃}XC}X̐ȓɓ邩ǂ𒲂ׂ
	 * @param p }X̍W
	 * @return }X̐ȓɓꍇ true Ԃ
	 */
	public boolean isTooClose(Address p) {
		return multi[p.r()][p.c()] > 1;
	}
	/**
	 * ̃}XƓ̈ɓ邩ǂ𒲂ׂ
	 * @param p }X̍W
	 * @return ̈ɓꍇ true Ԃ
	 */
	public boolean isMultipleNumber(Address p) {
		return multi2[p.r()][p.c()] > 1;
	}
	/**
	 * ̃}X̐C̈ʐς𒴂ĂȂǂ𒲂ׂ
	 * @param p }X̍W
	 * @return ̈ʐς𒴂̏ꍇ true Ԃ
	 */
	public boolean isTooLarge(Address p) {
		return getArea(p)!=null && getNumberOrState(p) > getArea(p).size() ;
	}
	/**
	 * ̍W̉\̃rbgp^[擾
	 * @param r row coordinate
	 * @param c column coordinate
	 * @return Returns the pattern.
	 */
	int getPattern(Address p){
		return hint.getPattern(p);
	}
	/**
	 * ̏ꏊɂ鐔[Ɉᔽɔzu\ǂ𒲂ׂ
	 * @param p }X̍W
	 * @param n zuł邩ǂ𒲂ׂ鐔
	 * @return zu\Ȃ true@Ԃ
	 */
	boolean canPlace(Address p, int n) {
		return hint.canPlace(p, n);
	}

	/**
	 * }Xɉ𓚐͂CAhDXi[ɒʒm
	 * @param p }XW
	 * @param n ͂鐔
	 */
	public void changeAnswerNumber(Address p, int n) {
		int prev = getState(p);
		if (n == prev)
			return;
		if (isStable(p)) {
			changeFixedNumber(p, Board.BLANK);
		}
		if (isRecordUndo())
			fireUndoableEditUpdate(new CellEditStep(EditType.NUMBER, p, prev, n));
		setState(p, n);
		changeNumber1(p, prev, n);
	}
	/**
	 * }Xɖ萔͂CAhDXi[ɒʒm
	 * @param p }XW
	 * @param n ͂鐔
	 */
	public void changeFixedNumber(Address p, int n) {
		int prev = getNumber(p);
		if (n == prev)
			return;
		if (getState(p) > 0) {
			changeAnswerNumber(p, Board.UNKNOWN);
		}
		if (isRecordUndo())
			fireUndoableEditUpdate(new CellEditStep(EditType.FIXED, p, prev, n));
		setNumber(p, n);
		changeNumber1(p, prev, n);
	}

	private void changeNumber1(Address p, int prev, int n) {
		updateMulti(p, prev, n);
		if (getArea(p) != null)
			updateMulti2(p, prev, n);
		if (prev == 0 && n > 0)
			hint.checkUsedNumber(p, n);
		else
			hint.initHint();
	}

	public void undo(AbstractStep step) {
		if (step instanceof CellEditStep) {
			CellEditStep s = (CellEditStep) step;
			if (s.getType() == EditType.NUMBER) {
				changeAnswerNumber(s.getPos(), s.getBefore());
			} else if (s.getType() == EditType.FIXED) {
				changeFixedNumber(s.getPos(), s.getBefore());
			}
		} else if (step instanceof AreaEditStep) {
			AreaEditStep s = (AreaEditStep) step;
			if (s.getOperation() == AreaEditStep.ADDED) {
				removeCell(s.getPos());
			} else if (s.getOperation() == AreaEditStep.REMOVED) {
				addCell(s.getP0(), s.getPos());
			}
		}
	}

	public void redo(AbstractStep step) {
		if (step instanceof CellEditStep) {
			CellEditStep s = (CellEditStep) step;
			if (s.getType() == EditType.NUMBER) {
				changeAnswerNumber(s.getPos(), s.getAfter());
			} else if (s.getType() == EditType.FIXED) {
				changeFixedNumber(s.getPos(), s.getAfter());
			}
		} else if (step instanceof AreaEditStep) {
			AreaEditStep s = (AreaEditStep) step;
			if (s.getOperation() == AreaEditStep.ADDED) {
				addCell(s.getP0(), s.getPos());
			} else if (s.getOperation() == AreaEditStep.REMOVED) {
				removeCell(s.getPos());
			}
		}
	}
	/**
	 * }Xp  p0 Ɠ̈ɂB p0 NOWHWERȂΐV̈
	 * @param p0
	 * @param p
	 */
	void addCell(Address p0, Address p) {
		if (Address.NOWHERE.equals(p0)) { 
			Area a = new Area();
			addCellToArea(p, a);
		} else {
			Area a = getArea(p0);
			if (a != null) {
				addCellToArea(p, a);
			}
		}
	}
	/**
	 * }X p ̈悩菜B
	 * @param p
	 */
	void removeCell(Address p) {
		Area a = getArea(p);
		if (a != null) {
			removeCellFromArea(p, a);
		}
	}
	/**
	 * }Ẍɒǉ
	 * @param p ǉ}X̍W
	 * @param a ǉ̈
	 */
	public void addCellToArea(Address p, Area a) {
		if (isRecordUndo()) {
			Address p0 = Address.NOWHERE;
			if (a.size() > 0) {
				p0 = a.getTopCell(Address.NOWHERE);
			}
			fireUndoableEditUpdate(new AreaEditStep(p, p0, AreaEditStep.ADDED));
		}
		if (a.isEmpty()) {
			areaList.add(a);
		}
		setArea(p, a);
		a.add(p);
//		initArea(a);
	}
	/**
	 * }Ẍ悩菜
	 * @param p 菜}X̍W
	 * @param a 菜̈
	 */
	public void removeCellFromArea(Address p, Area a) {
		if (isRecordUndo()) {
			Address p0 = Address.NOWHERE;
			if (a.size() > 1) {
				p0 = a.getTopCell(p);
			}
			fireUndoableEditUpdate(new AreaEditStep(p, p0, AreaEditStep.REMOVED));
		}
		setArea(p, null);
		a.remove(p);
		if (a.isEmpty()) {
			areaList.remove(a);
		} else {
//			initArea(a);
		}
	}
	/**
	 * V̈ǉ
	 * @param newArea
	 */
	public void addArea(Area newArea) {
		for (Address p : newArea) {
			setArea(p, newArea);
		}
		areaList.add(newArea);
	}
	/**
	 * ̈悷ׂẴ}Xǉ
	 * @param newArea
	 */
	public void addWholeArea(Area newArea) {
		Address[] cells = newArea.toArray(new Address[0]);
		for (Address p : cells) {
			addCellToArea(p, newArea);
		}
	}
	/**
	 * ׂ̈̂Ẵ}Ẍ悩珜ė̈폜
	 * @param oldArea
	 */
	public void removeWholeArea(Area oldArea) {
		Address[] cells = oldArea.toArray(new Address[0]);
		for (Address p : cells) {
			removeCellFromArea(p, oldArea);
		}
	}
	/**
	 * @return Returns the areaList.
	 */
	List<Area> getAreaList() {
		return areaList;
	}

	/**
	 * @return Returns the number.
	 */
	int[][] getNumber() {
		return number;
	}
	/**
	 * @return Returns the state.
	 */
	int[][] getState() {
		return state;
	}

	public void initBoard() {
		initMulti();
		initMulti2();
		hint.initHint();
	}
	/**
	 * ݂̔Ֆʂɂċ̏d\multiz߂
	 */
	void initMulti() {
		for (Address p : cellAddrs()) {
			int n = getNumberOrState(p);
			if (n > 0) {
				multi[p.r()][p.c()] = 1;
				updateMulti1(p, n, +1, 0);
			} else {
				multi[p.r()][p.c()] = 0;
			}
		}
	}

	/**
	 * }X̐ύXꂽƂɁCɉċ̏d\multizXV
	 * @param p0 ̕ύXꂽ}X̍W
	 * @param prev ύXO̐
	 * @param num ύX̐
	 */
	void updateMulti(Address p0, int prev, int num) {
		int r0 = p0.r(), c0 = p0.c();
		if (multi[r0][c0]>1) {
			updateMulti1(p0, prev, 0, -1);
		}
		if (num > 0) {
			multi[r0][c0] = 1;
			updateMulti1(p0, num, +1, +1);
		} else if (num <= 0) {
			multi[r0][c0]=0;
		}
	}
	/**
	 * p0̐̕ύXɉďd𐔂multi[][]zXV
	 * ͈͂̐āCnum Ɠ̃}Xp0̒m, ̃}X̒kύXB
	 * @param p0 ԂύX}X̍W
	 * @param num ׂ鐔
	 * @param m ̏dXV
	 * @param k ̏dXV
	 */
	private void updateMulti1(Address p0, int num, int m, int k) {
		for (int d=0; d<4; d++) {
			Address p = p0;
			for (int l=1; l<=num; l++) {
				p = Address.nextCell(p, d);
				if (!isOn(p))
					break;
				if (getNumberOrState(p) == num) {
					multi[p.r()][p.c()] += k;
					multi[p0.r()][p0.c()] += m;
				}
			}
		}
	}
	/**
	 * ݂̔Ֆʂ̗̈̏d\multi2z߂B
	 */
	void initMulti2() {
		for (Address p : cellAddrs()) {
			int n = getNumberOrState(p);
			if (n>0 && getArea(p)!=null) {
				multi2[p.r()][p.r()] = 1;
				updateMulti21(p, n, +1, 0);
			} else {
				multi2[p.r()][p.c()] = 0;
			}
		}
	}
	/**
	 * }X̐ύXꂽƂɁCɉė̈̏d\multi2zXV
	 * @param p0 ̕ύXꂽ}X̍sW
	 * @param prev ύXO̐
	 * @param num ύX̐
	 */
	void updateMulti2(Address p0, int prev, int num) {
		int r0=p0.r(), c0=p0.c();
		if (multi2[r0][c0]>1) {
			updateMulti21(p0, prev, 0, -1);
		}
		if (num > 0) {
			multi2[r0][c0] = 1;
			updateMulti21(p0, num, +1, +1);
		} else if (num <= 0) {
			multi2[r0][c0]=0;
		}
	}
	/**
	 * p0̐̕ύXɉďd𐔂multi2[][]zXV
	 * ͈͂̐āCnum Ɠ̃}Xp0̒m, ̃}X̒kύXB
	 * @param p0 ԂύX}X̍W
	 * @param num ׂ鐔
	 * @param m ̏dXV
	 * @param k ̏dXV
	 */
	private void updateMulti21(Address p0, int num, int m, int k) {
		for (Address p : getArea(p0)) {
			if (p.equals(p0))
				continue;
			if (getNumberOrState(p) == num) { // ύX̐ƓC
				multi2[p.r()][p.c()] += k; // ύX̐ƓC
				multi2[p0.r()][p0.c()] += m; // ύXꂽ}X̏dm₷
			}
		}
	}

	public int checkAnswerCode() {
		int result = 0;
		for (Address p : cellAddrs()) {
			if (getNumberOrState(p) > 0 && isMultipleNumber(p))
				result |= 2;
			if (isTooLarge(p))
				result |= 4;
			if (isTooClose(p))
				result |= 8;
			if (getNumberOrState(p) <= 0)
				result |= 1;
		}
		return result;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result==0)
			return COMPLETE_MESSAGE;
		if (result==1)
			return Messages.getString("hakyukoka.AnswerCheckMessage1"); //$NON-NLS-1$
		StringBuffer message = new StringBuffer();
		if ((result&2) == 2)
			message.append(Messages.getString("hakyukoka.AnswerCheckMessage2")); //$NON-NLS-1$
		if ((result&4) == 4)
			message.append(Messages.getString("hakyukoka.AnswerCheckMessage3")); //$NON-NLS-1$
		if ((result&8) == 8)
			message.append(Messages.getString("hakyukoka.AnswerCheckMessage4")); //$NON-NLS-1$
		return message.toString();
	}

}
