/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tool;

import java.io.File;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.EventHandlerManager;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.MenuCommand;
import pencilbox.common.gui.PanelBase;
import pencilbox.common.gui.PanelImageWriter;
import pencilbox.common.gui.PreferencesCopierBase;
import pencilbox.common.io.IOController;

public class PngExport {
    private PencilType pencilType;
    private MenuCommand caller;
    PanelBase panel;
    private EventHandlerManager handler;
    Frame frame;

    public static void main(String[] args) {
        if (args.length < 2) {
            PngExport.printUsage();
            return;
        }
        PencilType pencilType = PencilType.getPencilType(args[0]);
        if (pencilType == null) {
            System.out.println("Illegal puzzletype : " + args[0]);
            PngExport.printUsage();
            return;
        }
        new PngExport(pencilType).run(args);
    }

    public PngExport(PencilType type) {
        this.pencilType = type;
    }

    public static final void printUsage() {
        System.out.println("Usage: java -jar pngexport.jar puzzletype datafiles");
    }

    public void run(String[] args) {
        System.out.println("puzzletype is " + args[0]);
        try {
            int i = 1;
            while (i < args.length) {
                File file = new File(args[i]);
                if (file.isFile()) {
                    System.out.println("Input file is  " + file.toString());
                    this.createNewFrame(file);
                    File pngFile = new File(file + ".png");
                    new PanelImageWriter().saveImageToFile(this.panel, pngFile);
                    System.out.println("Output file is  " + pngFile.toString());
                } else {
                    System.out.println("Cannot read file : " + file.toString());
                }
                ++i;
            }
        }
        catch (PencilBoxException e) {
            e.printStackTrace();
        }
    }

    public void createNewFrame(File file) throws PencilBoxException {
        Problem problem = IOController.getInstance(this.pencilType).openFile(file);
        MenuCommand command = new MenuCommand();
        this.frame = new Frame();
        this.panel = (PanelBase)ClassUtil.createInstance(this.pencilType, "Panel");
        this.handler = new EventHandlerManager(this.pencilType);
        this.frame.setup(this.panel);
        command.setup(this.pencilType, this.frame, this.panel, this.handler, problem);
        this.panel.setup(problem.getBoard());
        this.handler.setup(this.panel, problem.getBoard());
        this.copyPreferences(command);
    }

    private void copyPreferences(MenuCommand dst) throws PencilBoxException {
        PreferencesCopierBase copier = PreferencesCopierBase.createInstance(this.pencilType);
        if (this.caller == null) {
            File iniFile = new File("pencilbox.ini");
            if (iniFile.canRead()) {
                copier.loadPreferences(dst, iniFile);
            }
        } else {
            copier.copyPreferences(this.caller, dst);
        }
    }
}

