/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.factory;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilFactory;
import pencilbox.common.factory.PencilType;
import pencilbox.common.gui.FileChooser;
import pencilbox.resource.Messages;

public class PencilBoxLauncher {
    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        new PencilBoxLauncher();
        FileChooser.getProblemFileChooser();
    }

    public PencilBoxLauncher() {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(2);
        frame.setTitle("PencilBox");
        JPanel panel = new JPanel();
        List<PencilType> pencilTypeList = PencilType.getPencilTypeList();
        int n = pencilTypeList.size();
        panel.setLayout(new GridLayout(n, 1));
        for (PencilType p : pencilTypeList) {
            panel.add(this.makeButton(p));
        }
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }

    private JButton makeButton(final PencilType pencilType) {
        JButton button = new JButton(pencilType.getTitle());
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                try {
                    PencilFactory.getInstance(pencilType).createNewFrame();
                }
                catch (PencilBoxClassException e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
                }
            }
        });
        return button;
    }

    private JButton makeExitButton() {
        JButton button = new JButton(Messages.getString("PencilBoxLauncher.quit"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        return button;
    }
}

