/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int WHITE = -1;
    static final int BLACK = -2;
    static final int UNKNOWN = 0;
    static final int UNDECIDED_NUMBER = -1;
    private int[][] state;
    private int[][] number;
    private int[][] multiH;
    private int[][] multiV;
    private boolean[][] single;
    private int[][] chain;
    private int maxNumber;
    private int maxChain = 1;
    private int[] adjacentChain = new int[4];

    protected void setup() {
        super.setup();
        int rows = this.rows();
        int cols = this.cols();
        this.number = new int[rows][cols];
        this.state = new int[rows][cols];
        this.single = new boolean[rows][cols];
        this.multiH = new int[rows][cols];
        this.multiV = new int[rows][cols];
        this.chain = new int[rows][cols];
        this.maxNumber = rows > cols ? rows : cols;
    }

    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt2(this.state, 0);
        this.initBoard();
    }

    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) == -1) {
                    this.setState(r, c, 0);
                }
                ++c;
            }
            ++r;
        }
    }

    public void initBoard() {
        this.initSingle();
        this.initMulti();
        this.initChain();
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public boolean isBlack(int r, int c) {
        return this.isOn(r, c) && this.state[r][c] == -2;
    }

    public boolean isRedundantNumber(int r, int c) {
        return this.multiH[r][c] > 1 || this.multiV[r][c] > 1;
    }

    public boolean isSingle(int r, int c) {
        return this.single[r][c];
    }

    int getChain(int r, int c) {
        return this.chain[r][c];
    }

    void setBlack(int r, int c) {
        this.state[r][c] = -2;
        this.decreseMulti(r, c);
        this.connectChain(r, c);
    }

    void setWhite(int r, int c) {
        int before = this.state[r][c];
        this.state[r][c] = -1;
        if (before == -2) {
            this.increaseMulti(r, c);
            this.cutChain(r, c);
        }
    }

    public void erase(int r, int c) {
        int before = this.getState(r, c);
        this.state[r][c] = 0;
        if (before == -2) {
            this.increaseMulti(r, c);
            this.cutChain(r, c);
        }
    }

    public void changeState(int r, int c, int st) {
        if (st == -2) {
            this.setBlack(r, c);
        } else if (st == -1) {
            this.setWhite(r, c);
        } else if (st == 0) {
            this.erase(r, c);
        }
    }

    public void changeState(Address pos, int st) {
        this.changeState(pos.r(), pos.c(), st);
    }

    public void changeStateA(Address pos, int st) {
        this.fireUndoableEditUpdate(new CellEditStep(pos, this.getState(pos), st));
        this.changeState(pos, st);
    }

    public void undo(AbstractStep step) {
        CellEditStep s = (CellEditStep)step;
        this.changeState(s.getPos(), s.getBefore());
    }

    public void redo(AbstractStep step) {
        CellEditStep s = (CellEditStep)step;
        this.changeState(s.getPos(), s.getAfter());
    }

    boolean isBlock(int r, int c) {
        return this.isBlack(r - 1, c) || this.isBlack(r + 1, c) || this.isBlack(r, c - 1) || this.isBlack(r, c + 1);
    }

    boolean isBlock(Address pos) {
        return this.isBlock(pos.r(), pos.c());
    }

    void initChain() {
        int c;
        this.maxChain = 1;
        ArrayUtil.initArrayInt2(this.chain, 0);
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isOnPeriphery(r, c) && this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, 1) == -1) {
                    this.updateChain(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
        r = 1;
        while (r < this.rows() - 1) {
            c = 1;
            while (c < this.cols() - 1) {
                if (this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, ++this.maxChain) == -1) {
                    this.updateChain(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
    }

    int initChain1(int r, int c, int uu, int vv, int n) {
        if (n == 1 && uu != 0 && this.isOnPeriphery(r, c)) {
            return -1;
        }
        this.chain[r][c] = n >= 0 && this.isOnPeriphery(r, c) ? 1 : n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if ((u != -uu || v != -vv) && this.isBlack(r + u, c + v)) {
                    if (this.chain[r + u][c + v] == n) {
                        return -1;
                    }
                    if (this.initChain1(r + u, c + v, u, v, n) == -1) {
                        return -1;
                    }
                }
                v += 2;
            }
            u += 2;
        }
        return n;
    }

    void connectChain(int r, int c) {
        int[] adjacent = this.adjacentChain;
        int k = 0;
        int newChain = Integer.MAX_VALUE;
        if (this.isOnPeriphery(r, c)) {
            newChain = 1;
        }
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if (this.isBlack(r + u, c + v)) {
                    if (this.isOnPeriphery(r, c) && this.chain[r + u][c + v] == 1) {
                        newChain = -1;
                    }
                    adjacent[k] = this.chain[r + u][c + v];
                    int l = 0;
                    while (l < k) {
                        if (adjacent[k] == adjacent[l]) {
                            newChain = -1;
                        }
                        ++l;
                    }
                    ++k;
                    if (this.chain[r + u][c + v] < newChain) {
                        newChain = this.chain[r + u][c + v];
                    }
                }
                v += 2;
            }
            u += 2;
        }
        if (newChain == Integer.MAX_VALUE) {
            this.chain[r][c] = ++this.maxChain;
        } else {
            this.updateChain(r, c, newChain);
        }
    }

    void cutChain(int r, int c) {
        this.initChain();
    }

    void updateChain(int r, int c, int n) {
        this.chain[r][c] = n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if (this.isBlack(r + u, c + v) && this.chain[r + u][c + v] != n) {
                    this.updateChain(r + u, c + v, n);
                }
                v += 2;
            }
            u += 2;
        }
    }

    boolean checkDivision() {
        boolean ret = true;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols() - 1) {
                if (this.chain[r][c] == -1) {
                    ret = false;
                }
                ++c;
            }
            ++r;
        }
        return ret;
    }

    boolean checkContinuousBlack() {
        boolean ret = true;
        int r = 0;
        while (r < this.rows() - 1) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isBlack(r, c) && this.isBlock(r, c)) {
                    ret = false;
                }
                ++c;
            }
            ++r;
        }
        return ret;
    }

    boolean checkMulti() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isRedundantNumber(r, c)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    public int checkAnswerCode() {
        int result = 0;
        if (!this.checkContinuousBlack()) {
            result |= 1;
        }
        if (!this.checkDivision()) {
            result |= 2;
        }
        if (!this.checkMulti()) {
            result |= 4;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("hitori.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("hitori.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("hitori.AnswerCheckMessage3"));
        }
        return message.toString();
    }

    void initSingle() {
        int i;
        int c;
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                this.single[r][c] = true;
                ++c;
            }
            ++r;
        }
        int[] used = new int[this.maxNumber + 1];
        int r2 = 0;
        while (r2 < this.rows()) {
            i = 1;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int c2 = 0;
            while (c2 < this.cols()) {
                int n = this.number[r2][c2];
                used[n] = used[n] + 1;
                ++c2;
            }
            c2 = 0;
            while (c2 < this.cols()) {
                if (used[this.number[r2][c2]] > 1) {
                    this.single[r2][c2] = false;
                }
                ++c2;
            }
            ++r2;
        }
        c = 0;
        while (c < this.cols()) {
            i = 1;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int r3 = 0;
            while (r3 < this.rows()) {
                int n = this.number[r3][c];
                used[n] = used[n] + 1;
                ++r3;
            }
            r3 = 0;
            while (r3 < this.rows()) {
                if (used[this.number[r3][c]] > 1) {
                    this.single[r3][c] = false;
                }
                ++r3;
            }
            ++c;
        }
    }

    void initMulti() {
        int i;
        int[] used = new int[this.maxNumber + 1];
        int r = 0;
        while (r < this.rows()) {
            i = 0;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int c = 0;
            while (c < this.cols()) {
                if (this.state[r][c] != -2 && this.number[r][c] > 0) {
                    int n = this.number[r][c];
                    used[n] = used[n] + 1;
                }
                ++c;
            }
            c = 0;
            while (c < this.cols()) {
                this.multiH[r][c] = used[this.number[r][c]];
                ++c;
            }
            ++r;
        }
        int c = 0;
        while (c < this.cols()) {
            i = 0;
            while (i <= this.maxNumber) {
                used[i] = 0;
                ++i;
            }
            int r2 = 0;
            while (r2 < this.rows()) {
                if (this.state[r2][c] != -2 && this.number[r2][c] > 0) {
                    int n = this.number[r2][c];
                    used[n] = used[n] + 1;
                }
                ++r2;
            }
            r2 = 0;
            while (r2 < this.rows()) {
                this.multiV[r2][c] = used[this.number[r2][c]];
                ++r2;
            }
            ++c;
        }
    }

    private void decreseMulti(int r0, int c0) {
        int c = 0;
        while (c < this.cols()) {
            if (this.number[r0][c] == this.number[r0][c0]) {
                int[] nArray = this.multiH[r0];
                int n = c;
                nArray[n] = nArray[n] - 1;
            }
            ++c;
        }
        int r = 0;
        while (r < this.rows()) {
            if (this.number[r][c0] == this.number[r0][c0]) {
                int[] nArray = this.multiV[r];
                int n = c0;
                nArray[n] = nArray[n] - 1;
            }
            ++r;
        }
    }

    private void increaseMulti(int r0, int c0) {
        int c = 0;
        while (c < this.cols()) {
            if (this.number[r0][c] == this.number[r0][c0]) {
                int[] nArray = this.multiH[r0];
                int n = c;
                nArray[n] = nArray[n] + 1;
            }
            ++c;
        }
        int r = 0;
        while (r < this.rows()) {
            if (this.number[r][c0] == this.number[r0][c0]) {
                int[] nArray = this.multiV[r];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++r;
        }
    }

    int getMaxNumber() {
        return this.maxNumber;
    }

    int[][] getChain() {
        return this.chain;
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }
}

