/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.shikaku.Board;
import pencilbox.shikaku.Panel;
import pencilbox.shikaku.Square;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int pivotR = -1;
    private int pivotC = -1;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        Square sq = this.board.getSquare(pos);
        Square draggingSquare = sq == null ? new Square(pos, pos) : new Square(sq);
        this.fixPivot(draggingSquare, pos.r(), pos.c());
        this.setDraggingSquare(draggingSquare);
    }

    protected void leftDragged(Address pos) {
        Square draggingSquare = this.getDraggingSquare();
        if (draggingSquare == null) {
            return;
        }
        if (this.pivotR >= 0 && this.pivotC >= 0) {
            draggingSquare.set(this.pivotR, this.pivotC, pos.r(), pos.c());
        } else if (this.pivotR >= 0 && this.pivotC == -1) {
            draggingSquare.set(this.pivotR, draggingSquare.c0(), pos.r(), draggingSquare.c1());
        } else if (this.pivotR == -1 && this.pivotC >= 0) {
            draggingSquare.set(draggingSquare.r0(), this.pivotC, draggingSquare.r1(), pos.c());
        } else if (this.pivotR == -1) {
            // empty if block
        }
        this.fixPivot(draggingSquare, pos.r(), pos.c());
    }

    private void fixPivot(Square s, int r, int c) {
        if (this.pivotR == -1) {
            if (r == s.r0()) {
                this.pivotR = s.r1();
            } else if (r == s.r1()) {
                this.pivotR = s.r0();
            }
        }
        if (this.pivotC == -1) {
            if (c == s.c0()) {
                this.pivotC = s.c1();
            } else if (c == s.c1()) {
                this.pivotC = s.c0();
            }
        }
    }

    protected void leftReleased(Address pos) {
        int cp;
        Square draggingSquare = this.getDraggingSquare();
        if (draggingSquare == null) {
            return;
        }
        int rp = this.pivotR >= 0 ? this.pivotR : draggingSquare.r0();
        Square sq = this.board.getSquare(rp, cp = this.pivotC >= 0 ? this.pivotC : draggingSquare.c0());
        if (sq == null) {
            this.board.removeOverlappedSquares(draggingSquare, null);
            this.board.addSquareA(new Square(draggingSquare));
        } else if (sq.r0() != draggingSquare.r0() || sq.c0() != draggingSquare.c0() || sq.r1() != draggingSquare.r1() || sq.c1() != draggingSquare.c1()) {
            this.board.removeOverlappedSquares(draggingSquare, sq);
            this.board.changeSquareA(sq, draggingSquare);
        }
        this.setDraggingSquare(null);
        this.resetPivot();
    }

    protected void rightPressed(Address pos) {
        Square s = this.board.getSquare(pos);
        if (s != null) {
            this.board.removeSquareA(s);
        }
    }

    protected void rightDragged(Address pos) {
        Square s = this.board.getSquare(pos);
        if (s != null) {
            this.board.removeSquareA(s);
        }
    }

    private void resetPivot() {
        this.pivotR = -1;
        this.pivotC = -1;
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            Address posS;
            this.board.setNumber(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, -1);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, -1);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, -1);
            }
        }
    }

    void setDraggingSquare(Square draggingSquare) {
        ((Panel)this.getPanel()).setDraggingSquare(draggingSquare);
    }

    Square getDraggingSquare() {
        return ((Panel)this.getPanel()).getDraggingSquare();
    }
}

