/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SquareEditStep;
import pencilbox.resource.Messages;
import pencilbox.shikaku.Square;
import pencilbox.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board
extends BoardBase {
    static final int UNDECIDED_NUMBER = -1;
    private int[][] number;
    private Square[][] square;
    private List<Square> squareList;

    @Override
    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.square = new Square[this.rows()][this.cols()];
        this.squareList = new LinkedList<Square>();
    }

    @Override
    public void clearBoard() {
        super.clearBoard();
        this.squareList.clear();
        ArrayUtil.initArrayObject2(this.square, null);
    }

    int[][] getNumber() {
        return this.number;
    }

    @Override
    public void initBoard() {
        this.initSquares();
    }

    public void initSquares() {
        for (Square sq : this.squareList) {
            this.initSquare1(sq);
        }
    }

    public void initSquare1(Square sq) {
        int n = 0;
        int r = sq.r0();
        while (r <= sq.r1()) {
            int c = sq.c0();
            while (c <= sq.c1()) {
                if (this.isNumber(r, c)) {
                    n = n != 0 ? -2 : this.number[r][c];
                }
                this.square[r][c] = sq;
                ++c;
            }
            ++r;
        }
        sq.setNumber(n);
    }

    public void clearSquare1(Square sq) {
        int r = sq.r0();
        while (r <= sq.r1()) {
            int c = sq.c0();
            while (c <= sq.c1()) {
                this.square[r][c] = null;
                ++c;
            }
            ++r;
        }
    }

    List<Square> getSquareList() {
        return this.squareList;
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public boolean isNumber(int r, int c) {
        return this.number[r][c] > 0 || this.number[r][c] == -1;
    }

    public boolean isNumber(Address pos) {
        return this.isNumber(pos.r(), pos.c());
    }

    public Square getSquare(int r, int c) {
        return this.square[r][c];
    }

    public void setSquare(int r, int c, Square s) {
        this.square[r][c] = s;
    }

    public Square getSquare(Address pos) {
        return this.square[pos.r()][pos.c()];
    }

    public boolean isCovered(int r, int c) {
        return this.square[r][c] != null;
    }

    void removeOverlappedSquares(Square sq, Square org) {
        int r = sq.r0();
        while (r <= sq.r1()) {
            int c = sq.c0();
            while (c <= sq.c1()) {
                Square s = this.getSquare(r, c);
                if (s != null && s != org) {
                    this.removeSquareA(s);
                }
                ++c;
            }
            ++r;
        }
    }

    public void addSquareA(Square sq) {
        this.fireUndoableEditUpdate(new SquareEditStep(sq.r0(), sq.c0(), sq.r1(), sq.c1(), 1));
        this.addSquare(sq);
    }

    public void changeSquareA(Square sq, Square newSq) {
        int rOld = -1;
        int cOld = -1;
        int rNew = -1;
        int cNew = -1;
        if (sq.r0() == newSq.r0()) {
            rOld = sq.r1();
            rNew = newSq.r1();
        } else if (sq.r1() == newSq.r0()) {
            rOld = sq.r0();
            rNew = newSq.r1();
        } else if (sq.r0() == newSq.r1()) {
            rOld = sq.r1();
            rNew = newSq.r0();
        } else if (sq.r1() == newSq.r1()) {
            rOld = sq.r0();
            rNew = newSq.r0();
        }
        if (sq.c0() == newSq.c0()) {
            cOld = sq.c1();
            cNew = newSq.c1();
        } else if (sq.c1() == newSq.c0()) {
            cOld = sq.c0();
            cNew = newSq.c1();
        } else if (sq.c0() == newSq.c1()) {
            cOld = sq.c1();
            cNew = newSq.c0();
        } else if (sq.c1() == newSq.c1()) {
            cOld = sq.c0();
            cNew = newSq.c0();
        }
        this.fireUndoableEditUpdate(new SquareEditStep(rOld, cOld, rNew, cNew, 2));
        this.changeSquare(sq, newSq);
    }

    public void removeSquareA(Square sq) {
        this.fireUndoableEditUpdate(new SquareEditStep(sq.r0(), sq.c0(), sq.r1(), sq.c1(), 0));
        this.removeSquare(sq);
    }

    @Override
    public void undo(AbstractStep step) {
        SquareEditStep s = (SquareEditStep)step;
        if (s.getOperation() == 1) {
            this.removeSquare(s.getR0(), s.getC0());
        } else if (s.getOperation() == 0) {
            this.addSquare(s.getR0(), s.getC0(), s.getR1(), s.getC1());
        } else if (s.getOperation() == 2) {
            this.changeSquare(s.getR1(), s.getC1(), s.getR0(), s.getC0());
        }
    }

    @Override
    public void redo(AbstractStep step) {
        SquareEditStep s = (SquareEditStep)step;
        if (s.getOperation() == 1) {
            this.addSquare(s.getR0(), s.getC0(), s.getR1(), s.getC1());
        } else if (s.getOperation() == 0) {
            this.removeSquare(s.getR0(), s.getC0());
        } else if (s.getOperation() == 2) {
            this.changeSquare(s.getR0(), s.getC0(), s.getR1(), s.getC1());
        }
    }

    public void addSquare(Square sq) {
        this.initSquare1(sq);
        this.squareList.add(sq);
    }

    public void addSquare(int r0, int c0, int r1, int c1) {
        Square sq = new Square(r0, c0, r1, c1);
        this.addSquare(sq);
    }

    public void changeSquare(int rOld, int cOld, int rNew, int cNew) {
        Square sq = this.getSquare(rOld, cOld);
        this.clearSquare1(sq);
        sq.changeCorner(rOld, cOld, rNew, cNew);
        this.initSquare1(sq);
    }

    public void changeSquare(Square sq, Square newSq) {
        this.clearSquare1(sq);
        sq.set(newSq.r0(), newSq.c0(), newSq.r1(), newSq.c1());
        this.initSquare1(sq);
    }

    public void removeSquare(Square sq) {
        if (sq == null) {
            return;
        }
        this.clearSquare1(sq);
        this.squareList.remove(sq);
    }

    public void removeSquare(int r0, int c0) {
        Square sq = this.getSquare(r0, c0);
        this.removeSquare(sq);
    }

    @Override
    public int checkAnswerCode() {
        int errorCode = 0;
        int nNumber = 0;
        for (Square sq : this.squareList) {
            int n = sq.getNumber();
            if (n == -2) {
                errorCode |= 1;
                continue;
            }
            if (n == 0) {
                errorCode |= 2;
                continue;
            }
            if (n == -1) continue;
            if (n < sq.getSquareSize()) {
                errorCode |= 4;
                continue;
            }
            if (n <= sq.getSquareSize()) continue;
            errorCode |= 8;
        }
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isNumber(r, c)) {
                    ++nNumber;
                }
                if (this.square[r][c] == null) {
                    errorCode |= 0x10;
                }
                ++c;
            }
            ++r;
        }
        if (nNumber == 0) {
            errorCode = 32;
        }
        return errorCode;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 32) {
            return Messages.getString("shikaku.AnswerCheckMessage6");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage4"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("shikaku.AnswerCheckMessage5"));
        }
        return message.toString();
    }
}

