/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.bijutsukan;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.bijutsukan.Board;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private boolean showBeamMode = false;
    private boolean paintIlluminatedCellMode = true;
    private Color wallColor = Color.BLACK;
    private Color bulbColor = new Color(153);
    private Color illuminatedCellColor = new Color(0xAAFFFF);
    private Color noBulbColor = new Color(0xFF9999);

    public Panel() {
        this.setMarkStyle(3);
        this.setNumberColor(Color.WHITE);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public boolean isPaintIlluminatedCellMode() {
        return this.paintIlluminatedCellMode;
    }

    public void setPaintIlluminatedCellMode(boolean paintIlluminatedCellMode) {
        this.paintIlluminatedCellMode = paintIlluminatedCellMode;
    }

    public boolean isShowBeamMode() {
        return this.showBeamMode;
    }

    public void setShowBeamMode(boolean showRayMode) {
        this.showBeamMode = showRayMode;
    }

    public Color getIlluminatedCellColor() {
        return this.illuminatedCellColor;
    }

    public void setIlluminatedCellColor(Color illuminatedCellColor) {
        this.illuminatedCellColor = illuminatedCellColor;
    }

    public Color getBulbColor() {
        return this.bulbColor;
    }

    public void setBulbColor(Color bulbColor) {
        this.bulbColor = bulbColor;
    }

    public Color getNoBulbColor() {
        return this.noBulbColor;
    }

    public void setNoBulbColor(Color noBulbColor) {
        this.noBulbColor = noBulbColor;
    }

    public void setWallColor(Color wallColor) {
        this.wallColor = wallColor;
    }

    public Color getWallColor() {
        return this.wallColor;
    }

    public void drawBoard(Graphics2D g) {
        this.drawCells(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawCells(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getState(r, c);
                int l = this.board.getHorizIlluminated(r, c);
                int m = this.board.getVertIlluminated(r, c);
                if (this.isPaintIlluminatedCellMode() && (l > 0 || m > 0)) {
                    g.setColor(this.illuminatedCellColor);
                    this.paintCell(g, r, c);
                }
                if (state >= 0 && state <= 4) {
                    g.setColor(this.getWallColor());
                    this.paintCell(g, r, c);
                    g.setColor(this.getNumberColor());
                    if (this.isIndicateErrorMode() && this.board.checkAdjacentBulbs(r, c) <= 0) {
                        g.setColor(this.getErrorColor());
                    }
                    this.placeNumber(g, r, c, state);
                } else if (state == 5) {
                    g.setColor(this.getWallColor());
                    this.paintCell(g, r, c);
                } else if (state == -2) {
                    g.setColor(this.getBulbColor());
                    if (this.isIndicateErrorMode() && this.board.isMultiIlluminated(r, c)) {
                        g.setColor(this.getErrorColor());
                    }
                    this.placeFilledCircle(g, r, c);
                } else if (state == -3) {
                    g.setColor(this.getNoBulbColor());
                    this.placeMark(g, r, c);
                }
                if (this.isShowBeamMode()) {
                    g.setColor(this.getBulbColor());
                    if (l > 0) {
                        if (this.isIndicateErrorMode() && l > 1) {
                            g.setColor(this.getErrorColor());
                        }
                        this.placeCenterLine(g, r, c, 1);
                    }
                    g.setColor(this.getBulbColor());
                    if (m > 0) {
                        if (this.isIndicateErrorMode() && m > 1) {
                            g.setColor(this.getErrorColor());
                        }
                        this.placeCenterLine(g, r, c, 0);
                    }
                }
                ++c;
            }
            ++r;
        }
    }
}

