/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.numberlink;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.numberlink.Board;
import pencilbox.numberlink.Link;
import pencilbox.numberlink.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -9;
    private static final int INITAL = -9;
    private static final int PRESSED = -19;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        this.currentState = -19;
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        this.changeLineState(dragStart, dragEnd, 1);
    }

    protected void leftReleased(Address pos) {
        if (this.currentState == -19 && this.isOn(pos)) {
            Link link = this.board.getLink(pos);
            int newNumber = 0;
            if (this.board.isNumber(pos)) {
                newNumber = this.board.getNumber(pos);
            } else if (link != null) {
                newNumber = link.getNumber();
            }
            if (newNumber == this.getSelectedNumber() && this.getSelectedLink() == link) {
                this.setSelectedLink(null);
                this.setSelectedNumber(0);
            } else {
                this.setSelectedLink(link);
                this.setSelectedNumber(newNumber);
            }
        }
        this.currentState = -9;
    }

    private void changeLineState(Address pos0, Address pos1, int st) {
        int direction = pos0.getDirectionTo(pos1);
        if (direction < 0) {
            return;
        }
        SideAddress side = SideAddress.get(pos0, direction);
        if (this.currentState == -19) {
            this.currentState = this.board.getState(side) == st ? 0 : st;
        }
        Address p = pos0;
        while (!p.equals(pos1)) {
            side = SideAddress.get(p, direction);
            if (this.board.getState(side) != this.currentState) {
                this.board.changeStateA(side, this.currentState);
            }
            p = p.nextCell(direction);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            Address posS;
            this.board.setNumber(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, -1);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, -1);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, -1);
            }
        }
    }

    private Link getSelectedLink() {
        return ((Panel)this.getPanel()).getSelectedLink();
    }

    private void setSelectedLink(Link l) {
        ((Panel)this.getPanel()).setSelectedLink(l);
    }

    private int getSelectedNumber() {
        return ((Panel)this.getPanel()).getSelectedNumber();
    }

    private void setSelectedNumber(int n) {
        ((Panel)this.getPanel()).setSelectedNumber(n);
    }
}

