/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slitherlink;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Direction;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.slitherlink.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt3(s.getState(), d.getState());
        Rotator rotator2 = new Rotator(src.rows() - 1, src.cols() - 1, n);
        rotator2.rotateArrayInt2(s.getNumber(), d.getNumber());
    }

    public void copyRegion(BoardBase srcBoardBase, BoardBase dstBoardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)dstBoardBase;
        for (Address s : region) {
            Address dnrt;
            Address rt;
            Address d = this.translateAndRotateAddress(s, from, to, rotation);
            int[] nArray = Direction.DN_RT;
            int n = Direction.DN_RT.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (region.contains(Address.nextCell(s, n3))) {
                    int joint = srcBoard.getStateJ(s, n3);
                    int dir = Rotator2.rotateDirection(n3, rotation);
                    if (board.isSideOn(d, dir)) {
                        board.setStateJ(d, dir, joint);
                    }
                }
                ++n2;
            }
            Address dn = Address.nextCell(s, 2);
            if (!region.containsAll(dn, rt = Address.nextCell(s, 3), dnrt = Address.nextCell(dn, 3))) continue;
            int grid = srcBoard.getNumber(s);
            Address dd = null;
            if (rotation == 0 || rotation == 4) {
                dd = d;
            } else if (rotation == 1 || rotation == 7) {
                dd = Address.address(d.r() - 1, d.c());
            } else if (rotation == 2 || rotation == 6) {
                dd = Address.address(d.r() - 1, d.c() - 1);
            } else if (rotation == 3 || rotation == 5) {
                dd = Address.address(d.r(), d.c() - 1);
            }
            if (!board.isNumberOn(dd)) continue;
            board.setNumber(dd, grid);
        }
    }

    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            Address dn = Address.nextCell(s, 2);
            Address rt = Address.nextCell(s, 3);
            Address dnrt = Address.nextCell(dn, 3);
            int[] nArray = Direction.DN_RT;
            int n = Direction.DN_RT.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                if (region.contains(Address.nextCell(s, n3))) {
                    board.setStateJ(s, n3, 0);
                }
                ++n2;
            }
            if (!region.containsAll(dn, rt, dnrt)) continue;
            board.setNumber(s, -1);
        }
    }
}

