/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.lits;

import java.util.LinkedList;
import java.util.List;
import pencilbox.common.core.AbstractStep;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.CellEditStep;
import pencilbox.lits.Area;
import pencilbox.lits.Wall;
import pencilbox.resource.Messages;
import pencilbox.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board
extends BoardBase {
    public static final int WHITE = -1;
    public static final int BLACK = -2;
    public static final int UNKNOWN = 0;
    private List<Area> areaList;
    private Area[][] area;
    private int[][] state;
    private List<Wall> wallList;
    private Wall[][] wall;
    private Wall initializingWall;

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList<Area>();
        this.wall = new Wall[this.rows()][this.cols()];
        this.wallList = new LinkedList<Wall>();
    }

    @Override
    public void clearBoard() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                this.state[r][c] = 0;
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    @Override
    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.state[r][c] == -1) {
                    this.state[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public boolean isBlack(int r, int c) {
        return this.isOn(r, c) && this.state[r][c] == -2;
    }

    public Wall getWall(int r, int c) {
        return this.wall[r][c];
    }

    public void setWall(int r, int c, Wall a) {
        this.wall[r][c] = a;
    }

    public Area getArea(int r, int c) {
        if (!this.isOn(r, c)) {
            return null;
        }
        return this.area[r][c];
    }

    public Area getArea(Address pos) {
        return this.getArea(pos.r(), pos.c());
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void setArea(Address pos, Area a) {
        this.setArea(pos.r(), pos.c(), a);
    }

    public void addArea(Area newArea) {
        for (Address pos : newArea) {
            this.area[pos.r()][pos.c()] = newArea;
        }
        this.areaList.add(newArea);
    }

    public void removeArea(Area oldArea) {
        for (Address pos : oldArea) {
            if (this.area[pos.r()][pos.c()] != oldArea) continue;
            this.area[pos.r()][pos.c()] = null;
        }
        this.areaList.remove(oldArea);
    }

    public void addCellToArea(int r, int c, Area a) {
        if (a.isEmpty()) {
            this.areaList.add(a);
        }
        this.setArea(r, c, a);
        a.add(r, c);
    }

    public void addCellToArea(Address pos, Area a) {
        this.addCellToArea(pos.r(), pos.c(), a);
    }

    public void removeCellFromArea(int r, int c, Area a) {
        this.setArea(r, c, null);
        a.remove(r, c);
        if (a.isEmpty()) {
            this.areaList.remove(a);
        }
    }

    public void removeCellFromArea(Address pos, Area a) {
        this.removeCellFromArea(pos.r(), pos.c(), a);
    }

    public void changeState(int r, int c, int st) {
        int prevSt = this.getState(r, c);
        this.setState(r, c, st);
        Area a = this.getArea(r, c);
        if (a != null) {
            if (prevSt == -2) {
                a.getTetromino().remove(r, c);
            }
            if (st == -2) {
                a.getTetromino().add(r, c);
            }
        }
    }

    public void changeState(Address pos, int st) {
        this.changeState(pos.r(), pos.c(), st);
    }

    public void changeStateA(Address pos, int st) {
        this.fireUndoableEditUpdate(new CellEditStep(pos, this.getState(pos), st));
        this.changeState(pos, st);
    }

    @Override
    public void undo(AbstractStep step) {
        CellEditStep s = (CellEditStep)step;
        this.changeState(s.getPos(), s.getBefore());
    }

    @Override
    public void redo(AbstractStep step) {
        CellEditStep s = (CellEditStep)step;
        this.changeState(s.getPos(), s.getAfter());
    }

    List<Area> getAreaList() {
        return this.areaList;
    }

    int[][] getState() {
        return this.state;
    }

    @Override
    public void initBoard() {
        this.initTetrominos();
    }

    boolean is2x2Block(int r, int c) {
        if (this.isBlack(r, c)) {
            if (this.isBlack(r - 1, c)) {
                if (this.isBlack(r, c - 1) && this.isBlack(r - 1, c - 1)) {
                    return true;
                }
                if (this.isBlack(r, c + 1) && this.isBlack(r - 1, c + 1)) {
                    return true;
                }
            }
            if (this.isBlack(r + 1, c)) {
                if (this.isBlack(r, c - 1) && this.isBlack(r + 1, c - 1)) {
                    return true;
                }
                if (this.isBlack(r, c + 1) && this.isBlack(r + 1, c + 1)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        if (this.areaList.size() == 0) {
            result |= 1;
        }
        if (((result |= this.checkTetrominos()) & 8) == 0) {
            result |= this.checkAdjacentCongruousTetrominos();
        }
        result |= this.checkConnection();
        return result |= this.check2x2s();
    }

    public int checkTetrominos() {
        int result = 0;
        int[] count = new int[6];
        for (Area a : this.areaList) {
            int n = a.getTetrominoType();
            count[n] = count[n] + 1;
        }
        if (count[0] > 0) {
            result = 8;
        }
        return result;
    }

    public void initTetrominos() {
        for (Area a : this.areaList) {
            a.getTetromino().clear();
        }
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getArea(r, c) != null && this.getState(r, c) == -2) {
                    this.getArea(r, c).getTetromino().add(r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private int checkAdjacentCongruousTetrominos() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getArea(r, c) != null && this.getState(r, c) == -2) {
                    if (this.getArea(r, c + 1) != null && this.getArea(r, c) != this.getArea(r, c + 1) && this.getState(r, c + 1) == -2 && this.getArea(r, c).getTetrominoType() == this.getArea(r, c + 1).getTetrominoType()) {
                        result = 16;
                    }
                    if (this.getArea(r + 1, c) != null && this.getArea(r, c) != this.getArea(r + 1, c) && this.getState(r + 1, c) == -2 && this.getArea(r, c).getTetrominoType() == this.getArea(r + 1, c).getTetrominoType()) {
                        result = 16;
                    }
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    private int checkConnection() {
        ArrayUtil.initArrayObject2(this.wall, null);
        this.wallList.clear();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) == -2 && this.getWall(r, c) == null) {
                    if (this.wallList.size() > 0) {
                        return 32;
                    }
                    this.initWall(r, c);
                }
                ++c;
            }
            ++r;
        }
        return 0;
    }

    private void initWall(int r, int c) {
        this.initializingWall = new Wall();
        this.initWall1(r, c);
        this.wallList.add(this.initializingWall);
    }

    private boolean initWall1(int r, int c) {
        if (!this.isOn(r, c)) {
            return false;
        }
        if (!this.isBlack(r, c)) {
            return false;
        }
        if (this.getWall(r, c) == this.initializingWall) {
            return false;
        }
        this.initializingWall.add(r, c);
        this.setWall(r, c, this.initializingWall);
        this.initWall1(r - 1, c);
        this.initWall1(r, c - 1);
        this.initWall1(r + 1, c);
        this.initWall1(r, c + 1);
        return true;
    }

    private int check2x2s() {
        int result = 0;
        int r = this.rows() - 1;
        while (r >= 0) {
            int c = this.cols() - 1;
            while (c >= 0) {
                if (this.is2x2Block(r, c)) {
                    result |= 0x40;
                }
                --c;
            }
            --r;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("lits.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            // empty if block
        }
        if ((result & 4) == 4) {
            // empty if block
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("lits.AnswerCheckMessage2"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("lits.AnswerCheckMessage3"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("lits.AnswerCheckMessage4"));
        }
        if ((result & 0x40) == 64) {
            message.append(Messages.getString("lits.AnswerCheckMessage5"));
        }
        return message.toString();
    }
}

