/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.sudoku.Board;
import pencilbox.sudoku.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(this.board.rows());
    }

    private void setSelectedNumber(int n) {
        ((Panel)this.getPanel()).setSelectedNumber(n);
    }

    protected void leftPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos))) {
            int n = this.board.getNumber(pos);
            if (n >= this.getMaxInputNumber()) {
                this.board.enterNumberA(pos, 0);
            } else if (n >= 0) {
                this.board.enterNumberA(pos, n + 1);
            }
        }
        this.setSelectedNumber(this.board.getNumber(pos));
    }

    protected void rightPressed(Address pos) {
        if (!(this.isCursorOn() && !this.getCellCursor().isAt(pos) || this.board.isStable(pos))) {
            int n = this.board.getNumber(pos);
            if (n == 0) {
                this.board.enterNumberA(pos, this.getMaxInputNumber());
            } else if (n > 0) {
                this.board.enterNumberA(pos, n - 1);
            }
        }
        this.setSelectedNumber(this.board.getNumber(pos));
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                Address posS;
                this.board.changeNumber(pos, num);
                this.board.setState(pos, 1);
                if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && !this.board.isStable(posS)) {
                    this.board.setState(posS, 1);
                    this.board.changeNumber(posS, 0);
                }
            }
        } else if (this.isCursorOn() && num >= 0 && !this.board.isStable(pos)) {
            this.board.enterNumberA(pos, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, 0);
            this.board.setState(pos, 0);
            if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && this.board.isStable(posS)) {
                this.board.setState(posS, 0);
                this.board.changeNumber(posS, 0);
            }
        } else if (this.isCursorOn() && !this.board.isStable(pos)) {
            this.board.enterNumberA(pos, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, 0);
            this.board.setState(pos, 1);
            if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && !this.board.isStable(posS)) {
                this.board.setState(posS, 1);
                this.board.changeNumber(posS, 0);
            }
        }
    }
}

