/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.sudoku.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean highlightSelectionMode = false;
    private boolean indicateErrorMode = false;
    private boolean dotHintMode = false;
    private Color inputColor = new Color(153);
    private Color areaBorderColor = Color.BLACK;
    private int selectedNumber = 0;
    private Color highlightColor = Color.GREEN;
    private Color highlight2Color = new Color(0xFFFF80);
    private HintDot hintDot = new HintDot();
    private int unit;

    public Panel() {
        this.setCursorMode(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.unit = this.board.getUnit();
        if (this.unit >= 3 && this.unit <= 5) {
            this.hintDot.setDot(this, this.unit, this.getCellSize());
        }
    }

    protected int getSelectedNumber() {
        return this.selectedNumber;
    }

    protected void setSelectedNumber(int selectedNumber) {
        this.selectedNumber = selectedNumber;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public boolean isHighlightSelectionMode() {
        return this.highlightSelectionMode;
    }

    public void setHighlightSelectionMode(boolean highlightSelectionMode) {
        this.highlightSelectionMode = highlightSelectionMode;
    }

    public boolean isDotHintMode() {
        return this.dotHintMode;
    }

    public void setDotHintMode(boolean dotHintMode) {
        this.dotHintMode = dotHintMode;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        this.highlightColor = highlightColor;
    }

    public void setDisplaySize(int cellSize) {
        super.setDisplaySize(cellSize);
        this.hintDot.setDotSize(cellSize);
    }

    public void drawBoard(Graphics2D g) {
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
    }

    public void drawAreaBorders(Graphics2D g) {
        g.setColor(this.getAreaBorderColor());
        int r = 0;
        while (r <= this.rows()) {
            if (r % this.board.getUnit() == 0) {
                g.drawLine(this.toX(0), this.toY(r) - 1, this.toX(this.cols()), this.toY(r) - 1);
                g.drawLine(this.toX(0), this.toY(r), this.toX(this.cols()), this.toY(r));
                g.drawLine(this.toX(0), this.toY(r) + 1, this.toX(this.cols()), this.toY(r) + 1);
            }
            ++r;
        }
        int c = 0;
        while (c <= this.cols()) {
            if (c % this.board.getUnit() == 0) {
                g.drawLine(this.toX(c) - 1, this.toY(0), this.toX(c) - 1, this.toY(this.rows()));
                g.drawLine(this.toX(c), this.toY(0), this.toX(c), this.toY(this.rows()));
                g.drawLine(this.toX(c) + 1, this.toY(0), this.toX(c) + 1, this.toY(this.rows()));
            }
            ++c;
        }
    }

    protected void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int n = this.board.getNumber(r, c);
                this.paintCell1(g, r, c, n);
                if (n > 0) {
                    this.placeNumber1(g, r, c, n);
                } else if (n == 0) {
                    if (this.isDotHintMode() && this.unit >= 3 && this.unit <= 5) {
                        this.placeHintDot(g, r, c);
                    }
                    if (this.board.isStable(r, c)) {
                        g.setColor(this.getNumberColor());
                        this.placeBoldCircle(g, r, c);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private void paintCell1(Graphics2D g, int r, int c, int num) {
        if (this.isHighlightSelectionMode() && this.getSelectedNumber() > 0) {
            if (this.getSelectedNumber() == num) {
                g.setColor(this.highlightColor);
                this.paintCell(g, r, c);
            } else if (this.board.canPlace(r, c, this.getSelectedNumber())) {
                g.setColor(this.highlight2Color);
                this.paintCell(g, r, c);
            }
        }
    }

    private void placeNumber1(Graphics2D g, int r, int c, int num) {
        if (this.board.isStable(r, c)) {
            g.setColor(this.getNumberColor());
        } else {
            g.setColor(this.getInputColor());
            if (this.isIndicateErrorMode() && this.board.isMultipleNumber(r, c)) {
                g.setColor(this.getErrorColor());
            }
        }
        this.placeNumber(g, r, c, num);
    }

    private void placeHintDot(Graphics2D g, int r, int c) {
        int pat = this.board.getPattern(r, c);
        if (pat == 0) {
            this.hintDot.placeHintCross(g, r, c);
        } else {
            this.hintDot.placeHintDot(g, r, c, pat);
        }
    }
}

