/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.hashi.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Address pos;
        int c;
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        int r = 0;
        while (r < s.rows()) {
            c = 0;
            while (c < s.cols()) {
                pos = Address.address(r, c);
                if (d.isOn(pos = rotator.rotateAddress(pos))) {
                    d.setNumber(pos.r(), pos.c(), s.getNumber(r, c));
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < s.rows()) {
            c = 0;
            while (c < s.cols()) {
                pos = Address.address(r, c);
                if (d.isOn(pos = rotator.rotateAddress(pos))) {
                    int st = s.getState(r, c);
                    if (rotator.isTransposed()) {
                        d.setState(pos.r(), pos.c(), (st & 3) << 2 | (st & 0xC) >> 2);
                    } else {
                        d.setState(pos.r(), pos.c(), st);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, Area region, Address from, Address to, int rotation) {
        Address d;
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        for (Address s : region) {
            d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            board.setNumber(d, srcBoard.getNumber(s));
        }
        for (Address s : region) {
            d = this.translateAndRotateAddress(s, from, to, rotation);
            if (!board.isOn(d)) continue;
            int st = srcBoard.getState(s);
            if (Rotator2.isTransposed(rotation)) {
                board.setState(d, (st & 3) << 2 | (st & 0xC) >> 2);
                continue;
            }
            board.setState(d, st);
        }
    }

    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.setNumber(s, 0);
            board.setState(s, 0);
        }
    }
}

