/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import java.util.ArrayList;
import pencilbox.common.core.Address;
import pencilbox.common.core.SideAddress;
import pencilbox.common.io.PzprWriterBase;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Square;

public class PzprWriter
extends PzprWriterBase {
    private Board bd;

    protected String getPzprName() {
        return "heyawake";
    }

    protected void pzlexport() {
        this.bd = (Board)this.boardBase;
        this.outSize(this.bd.rows(), this.bd.cols());
        this.makeRoomNumberData();
        this.makeBorderData();
        this.encodeBorder();
        this.encodeRoomNumber16();
    }

    private void makeRoomNumberData() {
        int roomMax = 0;
        int[] roomId = new int[this.bd.rows() * this.bd.cols()];
        ArrayList<Square> rooms = new ArrayList<Square>();
        int cc = 0;
        while (cc < this.bd.rows() * this.bd.cols()) {
            Square sq;
            if (roomId[cc] == 0 && (sq = this.bd.getSquare(this.i2a(cc))) != null) {
                rooms.add(sq);
                ++roomMax;
                int r = sq.r0();
                while (r <= sq.r1()) {
                    int c = sq.c0();
                    while (c <= sq.c1()) {
                        roomId[r * this.cols + c] = roomMax;
                        ++c;
                    }
                    ++r;
                }
            }
            ++cc;
        }
        this.roomNumbers = new int[rooms.size()];
        int i = 0;
        while (i < rooms.size()) {
            this.roomNumbers[i] = ((Square)rooms.get(i)).getNumber();
            ++i;
        }
    }

    protected int getBorder(SideAddress p) {
        Address c1 = SideAddress.nextCellFromBorder(p, 0);
        Address c2 = SideAddress.nextCellFromBorder(p, 1);
        if (this.bd.getSquare(c1) != this.bd.getSquare(c2)) {
            return 1;
        }
        return 0;
    }
}

