/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.factory.PencilType;
import pencilbox.common.io.PclReaderBase;
import pencilbox.common.io.PclWriterBase;
import pencilbox.common.io.TxtReaderBase;
import pencilbox.common.io.TxtWriterBase;
import pencilbox.common.io.XmlReaderBase;
import pencilbox.common.io.XmlWriterBase;

public class IOController {
    private static final int EXT_PCL = 3;
    private static final int EXT_XML = 1;
    private PencilType pencilType;

    public static IOController getInstance(PencilType pencilType) {
        return new IOController(pencilType);
    }

    private IOController(PencilType pencilType) {
        this.pencilType = pencilType;
    }

    public Problem openFile(File file) throws PencilBoxException {
        Problem problem = null;
        BoardBase board = null;
        Reader in = null;
        InputStream is = null;
        try {
            try {
                switch (this.checkFileExt(file)) {
                    case 3: {
                        is = new FileInputStream(file);
                        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                        Document doc = builder.parse(is);
                        PclReaderBase pclReader = this.createPclReader();
                        problem = pclReader.makeProblem(doc);
                        break;
                    }
                    case 1: {
                        is = new FileInputStream(file);
                        XmlReaderBase xmlReader = this.createXmlReader();
                        problem = xmlReader.readProblem(is);
                        break;
                    }
                    default: {
                        in = new FileReader(file);
                        TxtReaderBase txtReader = this.createTxtReader();
                        board = txtReader.readProblem(in);
                        problem = new Problem(board);
                        break;
                    }
                }
            }
            catch (ParserConfigurationException e) {
                throw new PencilBoxException(e);
            }
            catch (SAXException e) {
                throw new PencilBoxException(e);
            }
            catch (IOException e) {
                throw new PencilBoxException(e);
            }
            catch (RuntimeException e) {
                throw new PencilBoxException(e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        problem.setFile(file);
        return problem;
    }

    public Problem readProblemData(String problemData) throws PencilBoxException {
        Problem problem = null;
        BoardBase board = null;
        Reader in = null;
        try {
            try {
                in = new StringReader(problemData.replace('/', '\n').replace('_', ' '));
                TxtReaderBase txtReader = this.createTxtReader();
                board = txtReader.readProblem(in);
                problem = new Problem(board);
            }
            catch (IOException e) {
                throw new PencilBoxException(e);
            }
            catch (RuntimeException e) {
                throw new PencilBoxException(e);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
        problem.setFile(null);
        return problem;
    }

    public void saveFile(Problem problem, File file) throws PencilBoxException {
        problem.setFile(file);
        PrintWriter out = null;
        try {
            try {
                switch (this.checkFileExt(file)) {
                    case 3: {
                        PclWriterBase pclWriter = this.createPclWriter();
                        Document doc = pclWriter.buildDocument(problem);
                        Transformer t = TransformerFactory.newInstance().newTransformer();
                        t.setOutputProperty("indent", "yes");
                        t.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(file)));
                        break;
                    }
                    case 1: {
                        XmlWriterBase xmlWriter = this.createXmlWriter();
                        out = xmlWriter.open(file);
                        xmlWriter.writeProblem(problem);
                        xmlWriter.close();
                        break;
                    }
                    default: {
                        TxtWriterBase txtWriter = this.createTxtWriter();
                        out = new PrintWriter(new FileWriter(file));
                        txtWriter.writeProblem(out, problem.getBoard());
                        out.close();
                        break;
                    }
                }
            }
            catch (IOException e) {
                throw new PencilBoxException(e);
            }
            catch (TransformerException e) {
                throw new PencilBoxException(e);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public String getProblemDataString(BoardBase board) throws PencilBoxClassException {
        TxtWriterBase txtWriter = this.createTxtWriter();
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        txtWriter.writeQuestion(out, board);
        String separator = System.getProperty("line.separator");
        String problemDataS = sw.toString().replace(separator, "/").replace(' ', '_');
        out.close();
        return problemDataS;
    }

    private int checkFileExt(File file) {
        String filename = file.getName();
        int len = filename.length();
        if (len >= 4) {
            if (filename.substring(len - 4).equals(".pcl")) {
                return 3;
            }
            if (filename.substring(len - 4).equals(".xml")) {
                return 1;
            }
        }
        return 0;
    }

    private XmlReaderBase createXmlReader() throws PencilBoxClassException {
        XmlReaderBase xmlReader = (XmlReaderBase)ClassUtil.createInstance(this.pencilType, "XmlReader");
        xmlReader.setPuzzleType(this.pencilType.getPencilName());
        return xmlReader;
    }

    private XmlWriterBase createXmlWriter() throws PencilBoxClassException {
        XmlWriterBase xmlWriter = (XmlWriterBase)ClassUtil.createInstance(this.pencilType, "XmlWriter");
        xmlWriter.setPuzzleType(this.pencilType.getPencilName());
        return xmlWriter;
    }

    private PclReaderBase createPclReader() throws PencilBoxClassException {
        PclReaderBase pclReader = (PclReaderBase)ClassUtil.createInstance(this.pencilType, "PclReader");
        return pclReader;
    }

    private PclWriterBase createPclWriter() throws PencilBoxClassException {
        PclWriterBase pclWriter = (PclWriterBase)ClassUtil.createInstance(this.pencilType, "PclWriter");
        return pclWriter;
    }

    private TxtReaderBase createTxtReader() throws PencilBoxClassException {
        TxtReaderBase txtReader = (TxtReaderBase)ClassUtil.createInstance(this.pencilType, "TxtReader");
        return txtReader;
    }

    private TxtWriterBase createTxtWriter() throws PencilBoxClassException {
        TxtWriterBase txtWriter = (TxtWriterBase)ClassUtil.createInstance(this.pencilType, "TxtWriter");
        return txtWriter;
    }
}

