/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator2;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;
import pencilbox.common.gui.EventHandlerManager;
import pencilbox.common.gui.PanelBase;

public class RegionEditHandler
implements KeyListener,
MouseListener,
MouseMotionListener {
    private PanelBase panel;
    private BoardBase board;
    private BoardCopierBase boardCopier;
    private EventHandlerManager eventHandlerManager;
    private Address oldPos = new Address(-1, -1);
    private Address newPos = new Address(-1, -1);
    private Area copyRegion;
    private Area pasteRegion;
    private Address copyRegionOrigin;
    private Address pasteRegionOrigin;
    private Address pivot = new Address();
    private int pasteRotation;

    public void setup(PanelBase panel, BoardBase board, EventHandlerManager eventHandlerManager) {
        this.eventHandlerManager = eventHandlerManager;
        this.panel = panel;
        this.board = board;
        try {
            this.boardCopier = (BoardCopierBase)ClassUtil.createInstance(board.getClass(), "BoardCopier");
        }
        catch (PencilBoxClassException e) {
            this.boardCopier = new BoardCopierBase();
        }
        this.copyRegion = panel.getCopyRegion();
        this.pasteRegion = panel.getPasteRegion();
        this.copyRegionOrigin = panel.getCopyRegionOrigin();
        this.pasteRegionOrigin = panel.getPasteRegionOrigin();
        this.pasteRotation = 0;
        this.init();
    }

    public void init() {
        this.copyRegion.clear();
        this.pasteRegion.clear();
        this.copyRegionOrigin.setNowhere();
        this.pasteRegionOrigin.setNowhere();
    }

    private boolean isMovingRegion() {
        return !this.pasteRegion.isEmpty();
    }

    public void repaint() {
        this.panel.repaint();
    }

    public boolean isOn(Address position) {
        return this.board.isOn(position);
    }

    public void keyPressed(KeyEvent e) {
        int keyCode = e.getKeyCode();
        switch (keyCode) {
            case 47: 
            case 111: {
                this.slashKeyEntered();
                break;
            }
            case 32: 
            case 46: 
            case 110: {
                this.spaceKeyEntered();
                break;
            }
            case 48: 
            case 96: {
                this.numberKeyEntered(0);
                break;
            }
            case 49: 
            case 97: {
                this.numberKeyEntered(1);
                break;
            }
            case 50: 
            case 98: {
                this.numberKeyEntered(2);
                break;
            }
            case 51: 
            case 99: {
                this.numberKeyEntered(3);
                break;
            }
            case 52: 
            case 100: {
                this.numberKeyEntered(4);
                break;
            }
            case 53: 
            case 101: {
                this.numberKeyEntered(5);
                break;
            }
            case 54: 
            case 102: {
                this.numberKeyEntered(6);
                break;
            }
            case 55: 
            case 103: {
                this.numberKeyEntered(7);
            }
        }
        this.repaint();
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    protected void numberKeyEntered(int number) {
        if (number >= 8) {
            return;
        }
        if (this.isMovingRegion()) {
            this.rotateArea(this.pasteRegion, this.pasteRegionOrigin, number);
            this.pasteRotation = Rotator2.combine(this.pasteRotation, number);
        }
    }

    protected void spaceKeyEntered() {
        this.boardCopier.eraseRegion(this.board, this.copyRegion);
        this.board.initBoard();
    }

    protected void slashKeyEntered() {
        this.eventHandlerManager.setEditMode(PanelBase.PROBLEM_INPUT_MODE);
    }

    public void mousePressed(MouseEvent e) {
        boolean ctrl;
        this.newPos.set(this.panel.pointToAddress(e.getX(), e.getY()));
        if (!this.isOn(this.newPos)) {
            return;
        }
        boolean shift = (e.getModifiersEx() & 0x40) != 0;
        boolean bl = ctrl = (e.getModifiersEx() & 0x80) != 0;
        if (e.getButton() == 1) {
            this.leftPressed(this.newPos, shift, ctrl);
        } else if (e.getButton() == 3) {
            this.rightPressed(this.newPos, shift, ctrl);
        }
        this.oldPos.set(this.newPos);
        this.repaint();
    }

    public void mouseDragged(MouseEvent e) {
        boolean shift;
        this.newPos.set(this.panel.pointToAddress(e.getX(), e.getY()));
        if (!this.isOn(this.newPos)) {
            return;
        }
        if (this.newPos.equals(this.oldPos)) {
            return;
        }
        boolean bl = shift = (e.getModifiersEx() & 0x40) != 0;
        if ((e.getModifiers() & 0x10) != 0) {
            this.leftDragged(this.newPos, shift);
        } else if ((e.getModifiers() & 4) != 0) {
            this.rightDragged(this.newPos);
        }
        this.oldPos.set(this.newPos);
        this.repaint();
    }

    public void mouseReleased(MouseEvent e) {
        boolean ctrl;
        boolean shift = (e.getModifiersEx() & 0x40) != 0;
        boolean bl = ctrl = (e.getModifiersEx() & 0x80) != 0;
        if (e.getButton() == 1) {
            this.leftDragFixed(this.oldPos, shift, ctrl);
        }
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    protected void leftPressed(Address position, boolean shift, boolean ctrl) {
        if (this.copyRegion.contains(position)) {
            this.copyArea(this.copyRegion, this.pasteRegion);
            this.copyRegionOrigin.set(position);
            this.pasteRegionOrigin.set(position);
        } else {
            if (!ctrl) {
                this.copyRegion.clear();
            }
            this.copyRegion.add(new Address(position));
            this.pivot.set(position);
        }
    }

    protected void leftDragged(Address position, boolean shift) {
        if (this.isMovingRegion()) {
            this.translateArea(this.pasteRegion, this.oldPos, this.newPos);
            this.pasteRegionOrigin.set(this.newPos);
        } else if (shift) {
            this.selectRectangularArea(position);
        } else {
            this.copyRegion.add(new Address(position));
            this.pivot.set(position);
        }
    }

    private void selectRectangularArea(Address position) {
        int r0 = this.pivot.r() < position.r() ? this.pivot.r() : position.r();
        int c0 = this.pivot.c() < position.c() ? this.pivot.c() : position.c();
        int r1 = this.pivot.r() < position.r() ? position.r() : this.pivot.r();
        int c1 = this.pivot.c() < position.c() ? position.c() : this.pivot.c();
        int r = r0;
        while (r <= r1) {
            int c = c0;
            while (c <= c1) {
                this.copyRegion.add(new Address(r, c));
                ++c;
            }
            ++r;
        }
    }

    protected void leftDragFixed(Address dragEnd, boolean shift, boolean ctrl) {
        if (this.isMovingRegion()) {
            if (ctrl) {
                this.boardCopier.copyRegion(this.board, this.copyRegion, this.copyRegionOrigin, this.pasteRegionOrigin, this.pasteRotation);
            } else {
                this.boardCopier.moveRegion(this.board, this.copyRegion, this.copyRegionOrigin, this.pasteRegionOrigin, this.pasteRotation);
            }
            this.board.initBoard();
            this.copyArea(this.pasteRegion, this.copyRegion);
            this.pasteRegion.clear();
            this.copyRegionOrigin.setNowhere();
            this.pasteRegionOrigin.setNowhere();
            this.pasteRotation = 0;
        }
    }

    protected void rightPressed(Address position, boolean shift, boolean ctrl) {
        if (ctrl) {
            this.copyRegion.remove(position);
        } else {
            this.copyRegion.clear();
            this.pasteRegion.clear();
            this.copyRegionOrigin.setNowhere();
            this.pasteRegionOrigin.setNowhere();
            this.pasteRotation = 0;
        }
    }

    protected void rightDragged(Address position) {
        this.copyRegion.remove(position);
    }

    private void copyArea(Area src, Area dst) {
        dst.clear();
        for (Address p : src) {
            if (!this.isOn(p)) continue;
            dst.add(new Address(p));
        }
    }

    private void translateArea(Area area, Address from, Address to) {
        for (Address pos : area) {
            pos.set(pos.r() + to.r() - from.r(), pos.c() + to.c() - from.c());
        }
    }

    private void rotateArea(Area area, Address center, int rotation) {
        Rotator2 rotator = new Rotator2(center, rotation);
        Area dst = new Area();
        for (Address p : area) {
            dst.add(rotator.rotateAddress(p));
        }
        area.clear();
        area.addAll(dst);
    }
}

