/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pencilbox.common.core.Property;
import pencilbox.common.gui.Messages;
import pencilbox.common.gui.PencilBoxDialog;

public class PropertyDialog
extends PencilBoxDialog {
    private static PropertyDialog instance = new PropertyDialog();
    private JPanel mainPanel;
    private JTextField fieldAuthor;
    private JTextField fieldDifficulty;
    private JTextField fieldSource;

    public static PropertyDialog getInstance() {
        return instance;
    }

    private PropertyDialog() {
    }

    protected void makeDialog() {
        super.makeDialog();
        this.makeMainPanel();
    }

    private void makeMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel labelAuthor = new JLabel(Messages.getString("PropertyDialog.labelAuthor"));
        JLabel labelDifficulty = new JLabel(Messages.getString("PropertyDialog.labelDifficulty"));
        JLabel labelSource = new JLabel(Messages.getString("PropertyDialog.labelSource"));
        this.fieldAuthor = new JTextField(12);
        this.fieldDifficulty = new JTextField(12);
        this.fieldSource = new JTextField(12);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets.top = 2;
        constraints.insets.bottom = 2;
        constraints.insets.left = 2;
        constraints.insets.right = 2;
        this.addComponent(labelAuthor, constraints, 0, 0, 1, 1);
        this.addComponent(this.fieldAuthor, constraints, 1, 0, 3, 1);
        this.addComponent(labelDifficulty, constraints, 0, 1, 1, 1);
        this.addComponent(this.fieldDifficulty, constraints, 1, 1, 3, 1);
        this.addComponent(labelSource, constraints, 0, 2, 1, 1);
        this.addComponent(this.fieldSource, constraints, 1, 2, 3, 1);
        this.add((Component)this.mainPanel, "North");
    }

    private void addComponent(Component c, GridBagConstraints constraints, int x, int y, int w, int h) {
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = w;
        constraints.gridheight = h;
        this.mainPanel.add(c, constraints);
    }

    public void setPropertyToDialog(Property p) {
        this.fieldAuthor.setText(p.getAuthor());
        this.fieldDifficulty.setText(p.getDifficulty());
        this.fieldSource.setText(p.getSource());
    }

    public void getPropertyFromDialog(Property p) {
        p.setAuthor(this.fieldAuthor.getText());
        p.setDifficulty(this.fieldDifficulty.getText());
        p.setSource(this.fieldSource.getText());
    }

    protected void setInitialFocus() {
        this.fieldAuthor.requestFocusInWindow();
    }

    protected void accept() {
        super.accept();
    }
}

