/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.gui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import pencilbox.common.gui.FileChooser;
import pencilbox.common.gui.PanelBase;

public class PanelImageWriter {
    private static final String formatName = "png";

    public void saveImage(PanelBase panel) {
        BufferedImage image = this.makePanelImage(panel);
        FileChooser chooser = FileChooser.getImageFileChooser();
        int r = chooser.showSaveDialog(null);
        if (r != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        try {
            ImageIO.write((RenderedImage)image, formatName, file);
        }
        catch (IOException exception) {
            JOptionPane.showMessageDialog(null, exception);
        }
    }

    public BufferedImage makePanelImage(PanelBase panel) {
        BufferedImage image = new BufferedImage(panel.getBoardRegionSize().width, panel.getBoardRegionSize().height, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, image.getWidth(), image.getHeight());
        panel.drawPanel(g2);
        return image;
    }
}

