/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.factory;

import pencilbox.common.core.Size;
import pencilbox.common.factory.Messages;

public final class PencilType {
    private static final PencilType[] pencilTypeList = new PencilType[]{new PencilType("kakuro", Messages.getString("PencilType.kakuro"), 12), new PencilType("kurodoko", Messages.getString("PencilType.kurodoko"), 9), new PencilType("shikaku", Messages.getString("PencilType.shikaku"), 10), new PencilType("sudoku", Messages.getString("PencilType.sudoku"), 9), new PencilType("slalom", Messages.getString("PencilType.slalom"), 10), new PencilType("slitherlink", Messages.getString("PencilType.slitherlink"), 11), new PencilType("tentaisho", Messages.getString("PencilType.tentaisho"), 10), new PencilType("numberlink", Messages.getString("PencilType.numberlink"), 10), new PencilType("nurikabe", Messages.getString("PencilType.nurikabe"), 10), new PencilType("hakyukoka", Messages.getString("PencilType.hakyukoka"), 10), new PencilType("hashi", Messages.getString("PencilType.hashi"), 9), new PencilType("bijutsukan", Messages.getString("PencilType.bijutsukan"), 10), new PencilType("hitori", Messages.getString("PencilType.hitori"), 8), new PencilType("fillomino", Messages.getString("PencilType.fillomino"), 10), new PencilType("heyawake", Messages.getString("PencilType.heyawake"), 10), new PencilType("masyu", Messages.getString("PencilType.masyu"), 10), new PencilType("yajilin", Messages.getString("PencilType.yajilin"), 10), new PencilType("lits", Messages.getString("PencilType.lits"), 10)};
    private String pencilName;
    private String title;
    private int defaultSize;

    public static int getNPencilType() {
        return pencilTypeList.length;
    }

    public static PencilType getPencilType(int i) {
        if (i >= 0 && i < pencilTypeList.length) {
            return pencilTypeList[i];
        }
        return null;
    }

    public static PencilType getPencilType(String name) {
        int i = 0;
        while (i < pencilTypeList.length) {
            if (pencilTypeList[i].getPencilName().equals(name)) {
                return pencilTypeList[i];
            }
            ++i;
        }
        return null;
    }

    private PencilType() {
    }

    private PencilType(String pencilName, String title, int defaultSize) {
        this.pencilName = pencilName;
        this.title = title;
        this.defaultSize = defaultSize;
    }

    public String getPencilName() {
        return this.pencilName;
    }

    public String getTitle() {
        return this.title;
    }

    public Size getDefaultSize() {
        return new Size(this.defaultSize, this.defaultSize);
    }
}

