/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SideAddress
implements Comparable<SideAddress> {
    public static final SideAddress NOWHERE = new SideAddress(-1, -1, -1);
    private int d;
    private int r;
    private int c;

    public static SideAddress get(Address pos, int dir) {
        switch (dir) {
            case 0: {
                return new SideAddress(1, pos.r() - 1, pos.c());
            }
            case 1: {
                return new SideAddress(0, pos.r(), pos.c() - 1);
            }
            case 2: {
                return new SideAddress(1, pos.r(), pos.c());
            }
            case 3: {
                return new SideAddress(0, pos.r(), pos.c());
            }
        }
        return NOWHERE;
    }

    public SideAddress() {
        this(0, 0, 0);
    }

    public SideAddress(SideAddress pos) {
        this(pos.d, pos.r, pos.c);
    }

    public SideAddress(int d, int r, int c) {
        this.d = d;
        this.r = r;
        this.c = c;
    }

    public int d() {
        return this.d;
    }

    public int r() {
        return this.r;
    }

    public int c() {
        return this.c;
    }

    public void set(int d, int r, int c) {
        this.d = d;
        this.r = r;
        this.c = c;
    }

    public void set(SideAddress pos) {
        this.d = pos.d();
        this.r = pos.r();
        this.c = pos.c();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SideAddress)) {
            return false;
        }
        SideAddress address = (SideAddress)o;
        return address.r == this.r && address.c == this.c && address.d == this.d;
    }

    public int hashCode() {
        return (this.d * 1000 + this.r) * 1000 + this.c;
    }

    public boolean isNowhere() {
        return this.r == -1 && this.c == -1;
    }

    public void setNowhere() {
        this.d = 0;
        this.r = -1;
        this.c = -1;
    }

    @Override
    public int compareTo(SideAddress o) {
        if (this.d < o.d) {
            return -1;
        }
        if (this.d > o.d) {
            return 1;
        }
        if (this.r < o.r) {
            return -1;
        }
        if (this.r > o.r) {
            return 1;
        }
        if (this.r < o.r) {
            return -1;
        }
        if (this.c < o.c) {
            return -1;
        }
        if (this.c > o.c) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return "[" + this.d + "," + this.r + "," + this.c + "]";
    }
}

