/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Address;

public class Rotator2 {
    private int rotation = 0;
    private int rows2;
    private int cols2;

    public static boolean isTransposed(int n) {
        switch (n) {
            case 0: 
            case 2: 
            case 5: 
            case 7: {
                return false;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    public static int combine(int a, int b) {
        int r = a;
        if (a >= 0 && a <= 3) {
            r = b / 4 * 4 + (a + b) % 4;
        } else if (a >= 4 && a <= 7) {
            r = (7 - b) / 4 * 4 + (a + (8 - b)) % 4;
        }
        return r;
    }

    public Rotator2() {
    }

    public Rotator2(int rows, int cols, int rotation) {
        this.rows2 = rows * 2;
        this.cols2 = cols * 2;
        this.rotation = rotation;
    }

    public Rotator2(Address center, int rotation) {
        this(center.r(), center.c(), rotation);
    }

    public void setup(int rows, int cols, int rotation) {
        this.rows2 = rows * 2;
        this.cols2 = cols * 2;
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isTransposed() {
        return Rotator2.isTransposed(this.rotation);
    }

    public Address rotateAddress(Address pos) {
        Address dst = new Address();
        switch (this.rotation) {
            case 0: {
                dst.set(pos.r(), pos.c());
                break;
            }
            case 1: {
                dst.set((this.rows2 + this.cols2) / 2 - pos.c(), (this.cols2 - this.rows2) / 2 + pos.r());
                break;
            }
            case 2: {
                dst.set(this.rows2 - pos.r(), this.cols2 - pos.c());
                break;
            }
            case 3: {
                dst.set((this.rows2 - this.cols2) / 2 + pos.c(), (this.cols2 + this.rows2) / 2 - pos.r());
                break;
            }
            case 4: {
                dst.set((this.rows2 - this.cols2) / 2 + pos.c(), (this.cols2 - this.rows2) / 2 + pos.r());
                break;
            }
            case 5: {
                dst.set(pos.r(), this.cols2 - pos.c());
                break;
            }
            case 6: {
                dst.set((this.rows2 + this.cols2) / 2 - pos.c(), (this.cols2 + this.rows2) / 2 - pos.r());
                break;
            }
            case 7: {
                dst.set(this.rows2 - pos.r(), pos.c());
            }
        }
        return dst;
    }

    public int rotateDirection(int direction) {
        switch (this.rotation) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                direction = (direction + this.rotation) % 4;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                direction = (direction + this.rotation) % 4;
                direction ^= 1;
            }
        }
        return direction;
    }
}

