/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.common.core;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Size;
import pencilbox.common.factory.ClassUtil;
import pencilbox.common.factory.PencilBoxClassException;

public class BoardCopierBase {
    public BoardBase duplicateBoard(BoardBase src) throws PencilBoxClassException {
        return this.duplicateBoard(src, 0);
    }

    public BoardBase duplicateBoard(BoardBase src, int n) throws PencilBoxClassException {
        BoardBase dst = (BoardBase)ClassUtil.createInstance(this.getClass(), "Board");
        if (Rotator.isTransposed(n)) {
            dst.setSize(new Size(src.cols(), src.rows()));
        } else {
            dst.setSize(new Size(src.rows(), src.cols()));
        }
        this.copyBoardStates(src, dst, n);
        return dst;
    }

    public BoardBase duplicateBoard(BoardBase src, Size size) throws PencilBoxClassException {
        BoardBase dst = (BoardBase)ClassUtil.createInstance(this.getClass(), "Board");
        dst.setSize(size);
        this.copyBoardStates(src, dst, 0);
        return dst;
    }

    protected void copyBoardStates(BoardBase src, BoardBase dst, int n) {
    }

    public void eraseRegion(BoardBase board, Area region) {
    }

    public void copyRegion(BoardBase srcBoard, BoardBase board, Area region, Address from, Address to, int rotation) {
    }

    public void copyRegion(BoardBase board, Area region, Address from, Address to, int rotation) {
        try {
            BoardBase srcBoard = this.duplicateBoard(board);
            this.copyRegion(srcBoard, board, region, from, to, rotation);
        }
        catch (PencilBoxClassException e) {
            e.printStackTrace();
        }
    }

    public void moveRegion(BoardBase board, Area region, Address from, Address to, int rotation) {
        try {
            BoardBase srcBoard = this.duplicateBoard(board);
            this.eraseRegion(board, region);
            this.copyRegion(srcBoard, board, region, from, to, rotation);
        }
        catch (PencilBoxClassException e) {
            e.printStackTrace();
        }
    }
}

