/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import pencilbox.common.core.Address;
import pencilbox.hashi.Bridge;

class Pier {
    private Address pos;
    private Pier[] nextPier = new Pier[4];
    private Bridge[] bridge = new Bridge[4];
    private int number;
    private int chain;
    private int exit;

    Pier(int r, int c, int n) {
        this.setPos(new Address(r, c));
        this.number = n;
    }

    int totalBridges() {
        int ret = 0;
        int d = 0;
        while (d < 4) {
            ret += this.getNBridge(d);
            ++d;
        }
        return ret;
    }

    int necessity() {
        return this.number - this.totalBridges();
    }

    int getNumber() {
        return this.number;
    }

    void setNumber(int n) {
        this.number = n;
    }

    int getNBridge(int d) {
        if (this.bridge[d] == null) {
            return 0;
        }
        return this.bridge[d].getBridge();
    }

    void setNBridge(int d, int n) {
        if (this.bridge[d] == null) {
            return;
        }
        this.bridge[d].setBridge(n);
    }

    void increaseBridge(int d) {
        this.bridge[d].increaseBridge();
    }

    void decreaseBridge(int d) {
        this.bridge[d].decreaseBridge();
    }

    int getCapacity(int d) {
        if (this.bridge[d] == null) {
            return 0;
        }
        return this.bridge[d].getCapacity();
    }

    int totalCapacity() {
        int ret = 0;
        int d = 0;
        while (d < 4) {
            ret += this.getCapacity(d);
            ++d;
        }
        return ret;
    }

    void limitCapacity(int d, int n) {
        if (this.bridge[d] == null) {
            return;
        }
        this.bridge[d].limitCapacity(n);
    }

    int getChain() {
        return this.chain;
    }

    void setChain(int i) {
        this.chain = i;
    }

    void clear() {
        this.chain = 0;
        int d = 0;
        while (d < 4) {
            this.setNBridge(d, 0);
            ++d;
        }
    }

    void setPos(Address pos) {
        this.pos = pos;
    }

    Address getPos() {
        return this.pos;
    }

    void setNextPier(int d, Pier p) {
        this.nextPier[d] = p;
    }

    Pier getNextPier(int d) {
        return this.nextPier[d];
    }

    void setExit(int exit) {
        this.exit = exit;
    }

    int getExit() {
        return this.exit;
    }

    void setBridge(int d, Bridge b) {
        this.bridge[d] = b;
    }

    Bridge getBridge(int d) {
        return this.bridge[d];
    }
}

