/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.hashi.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    static final int HORIZ = 1;
    static final int VERT = 0;
    static final int UP = 0;
    static final int DN = 2;
    static final int LT = 1;
    static final int RT = 3;
    private Board board;

    public PanelEventHandler() {
        this.setMaxInputNumber(8);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        if (!this.board.isOn(dragStart)) {
            return;
        }
        if (!this.board.isPier(dragStart)) {
            return;
        }
        if (dragStart.r() == dragEnd.r()) {
            if (dragStart.c() < dragEnd.c()) {
                this.board.addBridgeA(dragStart, 3);
            } else if (dragStart.c() > dragEnd.c()) {
                this.board.addBridgeA(dragStart, 1);
            }
        } else if (dragStart.c() == dragEnd.c()) {
            if (dragStart.r() < dragEnd.r()) {
                this.board.addBridgeA(dragStart, 2);
            } else if (dragStart.r() > dragEnd.r()) {
                this.board.addBridgeA(dragStart, 0);
            }
        }
    }

    protected void rightDragged(Address dragStart, Address dragEnd) {
        if (!this.board.isOn(dragStart)) {
            return;
        }
        if (!this.board.isPier(dragStart)) {
            return;
        }
        if (dragStart.r() == dragEnd.r()) {
            if (dragStart.c() < dragEnd.c()) {
                this.board.removeBridgeA(dragStart, 3);
            } else if (dragStart.c() > dragEnd.c()) {
                this.board.removeBridgeA(dragStart, 1);
            }
        } else if (dragStart.c() == dragEnd.c()) {
            if (dragStart.r() < dragEnd.r()) {
                this.board.removeBridgeA(dragStart, 2);
            } else if (dragStart.r() > dragEnd.r()) {
                this.board.removeBridgeA(dragStart, 0);
            }
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num >= 1 && num <= 8) {
            Address posS;
            this.board.setNumber(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isPier(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, 9);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, 0);
            if (this.isSymmetricPlacementMode() && this.board.isPier(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos, 9);
            if (this.isSymmetricPlacementMode() && !this.board.isPier(posS = this.getSymmetricPosition(pos))) {
                this.board.setNumber(posS, 9);
            }
        }
    }
}

