/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.hashi.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Address pos;
        int c;
        Board s = (Board)src;
        Board d = (Board)dst;
        Address pos0 = new Address();
        Rotator rotator = new Rotator(src.getSize(), n);
        int r = 0;
        while (r < s.rows()) {
            c = 0;
            while (c < s.cols()) {
                pos0.set(r, c);
                pos = rotator.rotateAddress(pos0);
                if (d.isOn(pos)) {
                    d.setNumber(pos.r(), pos.c(), s.getNumber(r, c));
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < s.rows()) {
            c = 0;
            while (c < s.cols()) {
                pos0.set(r, c);
                pos = rotator.rotateAddress(pos0);
                if (d.isOn(pos)) {
                    int st = s.getState(r, c);
                    if (rotator.isTransposed()) {
                        d.setState(pos.r(), pos.c(), (st & 3) << 2 | (st & 0xC) >> 2);
                    } else {
                        d.setState(pos.r(), pos.c(), st);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    public void copyRegion(BoardBase srcBoardBase, BoardBase boardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)boardBase;
        Address d = new Address();
        Rotator2 rotator = new Rotator2(to, rotation);
        for (Address s : region) {
            d.set(s.r() + to.r() - from.r(), s.c() + to.c() - from.c());
            d.set(rotator.rotateAddress(d));
            if (!board.isOn(d)) continue;
            board.setNumber(d, srcBoard.getNumber(s));
        }
        for (Address s : region) {
            d.set(s.r() + to.r() - from.r(), s.c() + to.c() - from.c());
            d.set(rotator.rotateAddress(d));
            if (!board.isOn(d)) continue;
            int st = srcBoard.getState(s);
            if (rotator.isTransposed()) {
                board.setState(d, (st & 3) << 2 | (st & 0xC) >> 2);
                continue;
            }
            board.setState(d, st);
        }
    }

    public void eraseRegion(BoardBase boardBase, Area region) {
        Board board = (Board)boardBase;
        for (Address s : region) {
            board.setNumber(s.r(), s.c(), 0);
            board.setState(s.r(), s.c(), 0);
        }
    }
}

