/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.sudoku;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.sudoku.DigitPatternHint;
import pencilbox.sudoku.Messages;

public class Board
extends BoardBase {
    static final int UNSTABLE = 0;
    static final int STABLE = 1;
    static final int UNKNOWN = 0;
    private int maxNumber;
    private int[][] state;
    private int[][] number;
    private int unit = 0;
    private int[][] multi;
    private DigitPatternHint hint;

    protected void setup() {
        super.setup();
        this.maxNumber = this.rows();
        int s = 1;
        while (s < 10) {
            if (s * s == this.maxNumber) {
                this.unit = s;
                break;
            }
            ++s;
        }
        if (this.unit == 0) {
            throw new RuntimeException("\u4e0d\u6b63\u306a\u5927\u304d\u3055");
        }
        this.state = new int[this.maxNumber][this.maxNumber];
        this.number = new int[this.maxNumber][this.maxNumber];
        this.multi = new int[this.maxNumber][this.maxNumber];
        this.hint = new DigitPatternHint();
        this.hint.setupHint(this);
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isStable(r, c)) {
                    this.number[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initMulti();
        this.hint.initHint();
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }

    public int getUnit() {
        return this.unit;
    }

    public boolean isStable(int r, int c) {
        return this.state[r][c] == 1;
    }

    public boolean isStable(Address pos) {
        return this.isStable(pos.r(), pos.c());
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public boolean isUnknown(int r, int c) {
        return this.number[r][c] == 0;
    }

    public void initBoard() {
        this.initMulti();
        this.hint.initHint();
    }

    int getPattern(int r, int c) {
        return this.hint.getPattern(r, c);
    }

    boolean canPlace(int r, int c, int n) {
        return this.getNumber(r, c) == 0 && this.hint.canPlace(r, c, n);
    }

    public void enterNumberA(Address pos, int n) {
        if (n < 0 || n > this.maxNumber) {
            return;
        }
        if (n == this.getNumber(pos)) {
            return;
        }
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(pos.r(), pos.c(), this.getNumber(pos), n)));
        this.changeNumber(pos, n);
    }

    public void changeNumber(int r, int c, int n) {
        if (this.getNumber(r, c) == n) {
            return;
        }
        this.updateMulti(r, c, n);
        this.hint.updateHint(r, c, n);
        this.setNumber(r, c, n);
    }

    public void changeNumber(Address pos, int n) {
        this.changeNumber(pos.r(), pos.c(), n);
    }

    public boolean isMultipleNumber(int r, int c) {
        return this.multi[r][c] > 1;
    }

    void initMulti() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) > 0) {
                    this.initMulti1(r, c, this.getNumber(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    private void initMulti1(int r0, int c0, int num) {
        this.multi[r0][c0] = 1;
        int c = 0;
        while (c < this.cols()) {
            if (c != c0 && this.getNumber(r0, c) == num) {
                int[] nArray = this.multi[r0];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++c;
        }
        int r = 0;
        while (r < this.rows()) {
            if (r != r0 && this.getNumber(r, c0) == num) {
                int[] nArray = this.multi[r0];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++r;
        }
        int unit = this.getUnit();
        int r2 = r0 - r0 % unit;
        while (r2 < r0 - r0 % unit + unit) {
            int c2 = c0 - c0 % unit;
            while (c2 < c0 - c0 % unit + unit) {
                if ((r2 != r0 || c2 != c0) && this.getNumber(r2, c2) == num) {
                    int[] nArray = this.multi[r0];
                    int n = c0;
                    nArray[n] = nArray[n] + 1;
                }
                ++c2;
            }
            ++r2;
        }
    }

    void updateMulti(int r0, int c0, int num) {
        int prevNum = this.getNumber(r0, c0);
        if (this.multi[r0][c0] > 1) {
            this.decreaseMulti(r0, c0, prevNum);
        }
        if (num > 0) {
            this.increaseMulti(r0, c0, num);
        }
    }

    private void increaseMulti(int r0, int c0, int num) {
        this.multi[r0][c0] = 1;
        int c = 0;
        while (c < this.cols()) {
            if (c != c0 && this.getNumber(r0, c) == num) {
                int[] nArray = this.multi[r0];
                int n = c;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = this.multi[r0];
                int n2 = c0;
                nArray2[n2] = nArray2[n2] + 1;
            }
            ++c;
        }
        int r = 0;
        while (r < this.rows()) {
            if (r != r0 && this.getNumber(r, c0) == num) {
                int[] nArray = this.multi[r];
                int n = c0;
                nArray[n] = nArray[n] + 1;
                int[] nArray3 = this.multi[r0];
                int n3 = c0;
                nArray3[n3] = nArray3[n3] + 1;
            }
            ++r;
        }
        int unit = this.getUnit();
        int r2 = r0 - r0 % unit;
        while (r2 < r0 - r0 % unit + unit) {
            int c2 = c0 - c0 % unit;
            while (c2 < c0 - c0 % unit + unit) {
                if ((r2 != r0 || c2 != c0) && this.getNumber(r2, c2) == num) {
                    int[] nArray = this.multi[r2];
                    int n = c2;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray4 = this.multi[r0];
                    int n4 = c0;
                    nArray4[n4] = nArray4[n4] + 1;
                }
                ++c2;
            }
            ++r2;
        }
    }

    private void decreaseMulti(int r0, int c0, int prevNum) {
        int c = 0;
        while (c < this.cols()) {
            if (c != c0 && this.getNumber(r0, c) == prevNum) {
                int[] nArray = this.multi[r0];
                int n = c;
                nArray[n] = nArray[n] - 1;
            }
            ++c;
        }
        int r = 0;
        while (r < this.rows()) {
            if (r != r0 && this.getNumber(r, c0) == prevNum) {
                int[] nArray = this.multi[r];
                int n = c0;
                nArray[n] = nArray[n] - 1;
            }
            ++r;
        }
        int unit = this.getUnit();
        int r2 = r0 - r0 % unit;
        while (r2 < r0 - r0 % unit + unit) {
            int c2 = c0 - c0 % unit;
            while (c2 < c0 - c0 % unit + unit) {
                if ((r2 != r0 || c2 != c0) && this.getNumber(r2, c2) == prevNum) {
                    int[] nArray = this.multi[r2];
                    int n = c2;
                    nArray[n] = nArray[n] - 1;
                }
                ++c2;
            }
            ++r2;
        }
    }

    public int checkAnswerCode() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isMultipleNumber(r, c)) {
                    result |= 1;
                }
                if (this.getNumber(r, c) == 0) {
                    result |= 2;
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 2) {
            return Messages.getString("Board.AnswerCheckMessage2");
        }
        if ((result & 1) == 1) {
            return Messages.getString("Board.AnswerCheckMessage1");
        }
        return "";
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (Board.this.isStable(this.row, this.col)) {
                return;
            }
            Board.this.changeNumber(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (Board.this.isStable(this.row, this.col)) {
                return;
            }
            Board.this.changeNumber(this.row, this.col, this.after);
        }

        public boolean addEdit(UndoableEdit anEdit) {
            Step edit = (Step)anEdit;
            if (edit.row == this.row && edit.col == this.col) {
                this.after = edit.after;
                return true;
            }
            return false;
        }
    }
}

