/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.kurodoko.Messages;
import pencilbox.kurodoko.Number;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int HORIZ = 1;
    static final int VERT = 0;
    static final int WHITE = -1;
    static final int BLACK = -2;
    static final int UNKNOWN = 0;
    static final int OUT = -3;
    static int UNDECIDED_NUMBER = -4;
    private int[][] state;
    private int[][] chain;
    private int maxChain;
    private Number[][] number;
    private int[] adjacentChain = new int[4];
    static final String ERR_CONTINUOUS_BLACK = Messages.getString("Board.AnswerCheckMessage1");
    static final String ERR_DIVIDED_BOARD = Messages.getString("Board.AnswerCheckMessage2");
    static final String ERR_SMALL_SIZE = Messages.getString("Board.AnswerCheckMessage3");
    static final String YET_LARGE_SIZE = Messages.getString("Board.AnswerCheckMessage4");

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.chain = new int[this.rows()][this.cols()];
        this.number = new Number[this.rows()][this.cols()];
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.state[r][c] == -2 || this.state[r][c] == -1) {
                    this.state[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) == -1) {
                    this.setState(r, c, 0);
                }
                ++c;
            }
            ++r;
        }
        this.initNumber();
    }

    int[][] getState() {
        return this.state;
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public boolean isNumber(int r, int c) {
        return this.state[r][c] > 0;
    }

    public boolean isNumber(Address pos) {
        return this.isNumber(pos.r(), pos.c());
    }

    public boolean isBlack(int r, int c) {
        return this.isOn(r, c) && this.state[r][c] == -2;
    }

    public boolean isWhiteOrNumber(int r, int c) {
        return this.state[r][c] == -1 || this.state[r][c] > 0 || this.state[r][c] == UNDECIDED_NUMBER;
    }

    public void initBoard() {
        this.initChain();
        this.initNumber();
    }

    void initNumber() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isNumber(r, c)) {
                    this.number[r][c] = new Number(this.getState(r, c));
                    this.initNumber(r, c);
                } else {
                    this.number[r][c] = null;
                }
                ++c;
            }
            ++r;
        }
    }

    public Number getNumber(int r, int c) {
        return this.number[r][c];
    }

    public Number getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.setState(r, c, n);
        this.number[r][c] = new Number(n);
        this.initNumber(r, c);
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    int getChain(int r, int c) {
        return this.chain[r][c];
    }

    public void changeState(int r, int c, int st) {
        int prevState = this.getState(r, c);
        this.setState(r, c, st);
        if (st == -2) {
            this.connectChain(r, c);
        } else if (prevState == -2) {
            this.cutChain(r, c);
        }
        this.updateSpace(r, c);
    }

    public void changeState(Address pos, int st) {
        this.changeState(pos.r(), pos.c(), st);
    }

    public void changeStateA(Address pos, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(pos.r(), pos.c(), this.getState(pos), st)));
        this.changeState(pos, st);
    }

    boolean isBlock(int r, int c) {
        return this.isBlack(r - 1, c) || this.isBlack(r + 1, c) || this.isBlack(r, c - 1) || this.isBlack(r, c + 1);
    }

    boolean isBlock(Address pos) {
        return this.isBlock(pos.r(), pos.c());
    }

    void initChain() {
        int c;
        this.maxChain = 1;
        ArrayUtil.initArrayInt2(this.chain, 0);
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isOnPeriphery(r, c) && this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, 1) == -1) {
                    this.setChain(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
        r = 1;
        while (r < this.rows() - 1) {
            c = 1;
            while (c < this.cols() - 1) {
                if (this.isBlack(r, c) && this.chain[r][c] == 0 && this.initChain1(r, c, 0, 0, ++this.maxChain) == -1) {
                    this.setChain(r, c, -1);
                }
                ++c;
            }
            ++r;
        }
    }

    int initChain1(int r, int c, int uu, int vv, int n) {
        if (n == 1 && uu != 0 && this.isOnPeriphery(r, c)) {
            return -1;
        }
        this.chain[r][c] = n >= 0 && this.isOnPeriphery(r, c) ? 1 : n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if ((u != -uu || v != -vv) && this.isBlack(r + u, c + v)) {
                    if (this.chain[r + u][c + v] == n) {
                        return -1;
                    }
                    if (this.initChain1(r + u, c + v, u, v, n) == -1) {
                        return -1;
                    }
                }
                v += 2;
            }
            u += 2;
        }
        return n;
    }

    void connectChain(int r, int c) {
        int[] adjacent = this.adjacentChain;
        int k = 0;
        int newChain = Integer.MAX_VALUE;
        if (this.isOnPeriphery(r, c)) {
            newChain = 1;
        }
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if (this.isBlack(r + u, c + v)) {
                    if (this.isOnPeriphery(r, c) && this.chain[r + u][c + v] == 1) {
                        newChain = -1;
                    }
                    adjacent[k] = this.chain[r + u][c + v];
                    int l = 0;
                    while (l < k) {
                        if (adjacent[k] == adjacent[l]) {
                            newChain = -1;
                        }
                        ++l;
                    }
                    ++k;
                    if (this.chain[r + u][c + v] < newChain) {
                        newChain = this.chain[r + u][c + v];
                    }
                }
                v += 2;
            }
            u += 2;
        }
        if (newChain == Integer.MAX_VALUE) {
            this.chain[r][c] = ++this.maxChain;
        } else {
            this.setChain(r, c, newChain);
        }
    }

    void cutChain(int r, int c) {
        this.initChain();
    }

    void setChain(int r, int c, int n) {
        this.chain[r][c] = n;
        int u = -1;
        while (u < 2) {
            int v = -1;
            while (v < 2) {
                if (this.isBlack(r + u, c + v) && this.chain[r + u][c + v] != n) {
                    this.setChain(r + u, c + v, n);
                }
                v += 2;
            }
            u += 2;
        }
    }

    int initNumber(int r0, int c0, int direction) {
        Address pos = new Address();
        int n = 0;
        pos.set(r0, c0);
        while (true) {
            pos.move(direction);
            if (!this.isOn(pos.r(), pos.c()) || this.isBlack(pos.r(), pos.c())) break;
            ++n;
        }
        this.number[r0][c0].setNSpace(direction, n);
        pos.set(r0, c0);
        n = 0;
        while (true) {
            pos.move(direction);
            if (!this.isOn(pos.r(), pos.c()) || !this.isWhiteOrNumber(pos.r(), pos.c())) break;
            ++n;
        }
        this.number[r0][c0].setNWhite(direction, n);
        if (this.number[r0][c0].tooSmallSpace()) {
            return -1;
        }
        if (this.number[r0][c0].tooLargeWhite()) {
            return -1;
        }
        return 0;
    }

    void initNumber(int r0, int c0) {
        this.initNumber(r0, c0, 0);
        this.initNumber(r0, c0, 2);
        this.initNumber(r0, c0, 1);
        this.initNumber(r0, c0, 3);
    }

    int updateSpace(int r0, int c0) {
        int ret = 0;
        Address pos = new Address();
        int d = 0;
        while (d < 4) {
            pos.set(r0, c0);
            while (true) {
                pos.move(d);
                if (!this.isOn(pos.r(), pos.c()) || this.isBlack(pos.r(), pos.c())) break;
                if (!this.isNumber(pos.r(), pos.c())) continue;
                ret += this.initNumber(pos.r(), pos.c(), d ^ 2);
            }
            ++d;
        }
        if (ret < 0) {
            return -1;
        }
        return 0;
    }

    int getSumSpace(int r, int c) {
        return this.number[r][c].getSumSpace();
    }

    int getSumWhite(int r, int c) {
        return this.number[r][c].getSumWhite();
    }

    public int checkAnswerCode() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isBlack(r, c)) {
                    if (this.isBlock(r, c)) {
                        result |= 1;
                    }
                    if (this.chain[r][c] == -1) {
                        result |= 2;
                    }
                }
                if (this.isNumber(r, c)) {
                    int remainder = this.number[r][c].getSumSpace() - this.number[r][c].getNumber();
                    if (remainder < 0) {
                        result |= 4;
                    } else if (remainder > 0) {
                        result |= 8;
                    }
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return BoardBase.COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(ERR_CONTINUOUS_BLACK);
        }
        if ((result & 2) == 2) {
            message.append(ERR_DIVIDED_BOARD);
        }
        if ((result & 4) == 4) {
            message.append(ERR_SMALL_SIZE);
        }
        if ((result & 8) == 8) {
            message.append(YET_LARGE_SIZE);
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.row, this.col, this.after);
        }
    }
}

