/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.yajilin.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = -9;

    public PanelEventHandler() {
        this.setMaxInputNumber(9);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        this.changeLineState(dragStart, dragEnd, 1);
    }

    protected void leftReleased(Address pos) {
        this.currentState = -9;
    }

    protected void leftClicked(Address pos) {
        this.toggleState(pos, -2);
    }

    protected void rightClicked(Address pos) {
        this.toggleState(pos, -1);
    }

    private void toggleState(Address pos, int st) {
        if (this.board.isNumber(pos)) {
            return;
        }
        if (st == this.board.getNumber(pos)) {
            st = -3;
        }
        if (st == -2) {
            this.board.eraseLinesAroundA(pos);
        }
        this.board.changeStateA(pos, st);
    }

    private void changeLineState(Address pos0, Address pos1, int st) {
        int direction = pos0.getDirectionTo(pos1);
        if (direction < 0) {
            return;
        }
        SideAddress side = SideAddress.get(pos0, direction);
        if (this.currentState == -9) {
            this.currentState = this.board.getState(side) == st ? 0 : st;
        }
        Address p = pos0;
        while (!p.equals(pos1)) {
            side = SideAddress.get(p, direction);
            if (!(this.board.getState(side) == this.currentState || this.board.hasNumberOrBlack(side) && st != 0)) {
                this.board.changeStateA(side, this.currentState);
            }
            p.move(direction);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.enterNumber(pos, num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.enterNumber(posS, -4);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.eraseNumber(pos);
            if (this.isSymmetricPlacementMode() && this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.eraseNumber(posS);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.enterNumber(pos, -4);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber(posS = this.getSymmetricPosition(pos))) {
                this.board.enterNumber(posS, -4);
            }
        }
    }
}

