/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import pencilbox.common.core.Address;
import pencilbox.common.core.Area;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.BoardCopierBase;
import pencilbox.common.core.Rotator;
import pencilbox.common.core.Rotator2;
import pencilbox.yajilin.Board;

public class BoardCopier
extends BoardCopierBase {
    public void copyBoardStates(BoardBase src, BoardBase dst, int n) {
        Board s = (Board)src;
        Board d = (Board)dst;
        Rotator rotator = new Rotator(src.getSize(), n);
        rotator.rotateArrayInt3(s.getState(), d.getState());
        Address pos0 = new Address();
        int r = 0;
        while (r < s.rows()) {
            int c = 0;
            while (c < s.cols()) {
                pos0.set(r, c);
                Address pos = rotator.rotateAddress(pos0);
                if (d.isOn(pos)) {
                    if (s.getNumber(pos0) >= 0) {
                        d.setArrowNumber(pos, s.getArrowNumber(pos0));
                        d.setArrowDirection(pos, rotator.rotateDirection(s.getArrowDirection(pos0)));
                    } else {
                        d.setNumber(pos, s.getNumber(pos0));
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    public void copyRegion(BoardBase srcBoardBase, BoardBase dstBoardBase, Area region, Address from, Address to, int rotation) {
        Board srcBoard = (Board)srcBoardBase;
        Board board = (Board)dstBoardBase;
        Address d = new Address();
        Address dn = new Address();
        Address rt = new Address();
        Rotator2 rotator = new Rotator2(to, rotation);
        for (Address s : region) {
            int dir;
            int joint;
            d.set(s.r() + to.r() - from.r(), s.c() + to.c() - from.c());
            d.set(rotator.rotateAddress(d));
            dn.set(s.r() + 1, s.c());
            rt.set(s.r(), s.c() + 1);
            if (region.contains(dn)) {
                joint = srcBoard.getStateJ(s, 2);
                dir = rotator.rotateDirection(2);
                board.setStateJ(d, dir, joint);
            }
            if (region.contains(rt)) {
                joint = srcBoard.getStateJ(s, 3);
                dir = rotator.rotateDirection(3);
                board.setStateJ(d, dir, joint);
            }
            if (!board.isOn(d)) continue;
            int number = srcBoard.getNumber(s);
            if (number >= 0 || number == -2) {
                board.eraseLinesAround(d);
            }
            board.setNumber(d, number);
            if (!board.isNumber(d)) continue;
            board.setArrowDirection(d, rotator.rotateDirection(srcBoard.getArrowDirection(s)));
        }
    }

    public void eraseRegion(BoardBase srcBoardBase, Area region) {
        Board board = (Board)srcBoardBase;
        Address dn = new Address();
        Address rt = new Address();
        for (Address s : region) {
            dn.set(s.r() + 1, s.c());
            rt.set(s.r(), s.c() + 1);
            if (region.contains(dn)) {
                board.setStateJ(s, 2, 0);
            }
            if (region.contains(rt)) {
                board.setStateJ(s, 3, 0);
            }
            board.setNumber(s, -3);
        }
    }
}

