/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.util.ArrayUtil;
import pencilbox.yajilin.Link;
import pencilbox.yajilin.Messages;

public class Board
extends BoardBase {
    private static final int HORIZ = 1;
    private static final int VERT = 0;
    static final int UNKNOWN = 0;
    static final int LINE = 1;
    static final int NOLINE = -1;
    static final int BLANK = -3;
    static final int WHITE = -1;
    static final int BLACK = -2;
    static final int OUTER = -9;
    static final int UNDECIDED_NUMBER = -4;
    private int[][] number;
    private int[][][] state;
    private List<Link> linkList;
    private Link[][][] link;
    private Link initializingLink;

    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        ArrayUtil.initArrayInt2(this.number, -3);
        this.state = new int[2][][];
        this.state[0] = new int[this.rows()][this.cols() - 1];
        this.state[1] = new int[this.rows() - 1][this.cols()];
        this.linkList = new LinkedList<Link>();
        this.link = new Link[2][][];
        this.link[0] = new Link[this.rows()][this.cols() - 1];
        this.link[1] = new Link[this.rows() - 1][this.cols()];
    }

    public boolean isBlack(int r, int c) {
        return this.isOn(r, c) && this.number[r][c] == -2;
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public int getArrowNumber(int r, int c) {
        return this.number[r][c] >= 0 ? this.number[r][c] & 0xF : -1;
    }

    public int getArrowNumber(Address pos) {
        return this.getArrowNumber(pos.r(), pos.c());
    }

    public void setArrowNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setArrowNumber(Address pos, int n) {
        this.setArrowNumber(pos.r(), pos.c(), n);
    }

    public int getArrowDirection(int r, int c) {
        return this.number[r][c] >= 0 ? this.number[r][c] >> 4 & 3 : -1;
    }

    public int getArrowDirection(Address pos) {
        return this.getArrowDirection(pos.r(), pos.c());
    }

    public void setArrowDirection(int r, int c, int dir) {
        if (dir < 0 || dir > 3) {
            return;
        }
        int[] nArray = this.number[r];
        int n = c;
        nArray[n] = nArray[n] & 0xFFFFFFCF;
        int[] nArray2 = this.number[r];
        int n2 = c;
        nArray2[n2] = nArray2[n2] | dir << 4;
    }

    public void setArrowDirection(Address pos, int dir) {
        this.setArrowDirection(pos.r(), pos.c(), dir);
    }

    public void toggleArrowDirection(Address pos) {
        int t = this.getArrowDirection(pos);
        if (t < 0) {
            return;
        }
        t = (t + 1) % 4;
        this.setArrowDirection(pos, t);
    }

    public boolean isNumber(int r, int c) {
        return this.number[r][c] >= 0 || this.number[r][c] == -4;
    }

    public boolean isNumber(Address pos) {
        return this.isNumber(pos.r(), pos.c());
    }

    public boolean hasNumberOrBlack(int d, int r, int c) {
        if (d == 0) {
            return this.isNumber(r, c) || this.isNumber(r, c + 1) || this.isBlack(r, c) || this.isBlack(r, c + 1);
        }
        if (d == 1) {
            return this.isNumber(r, c) || this.isNumber(r + 1, c) || this.isBlack(r, c) || this.isBlack(r + 1, c);
        }
        return false;
    }

    public boolean hasNumberOrBlack(SideAddress side) {
        return this.hasNumberOrBlack(side.d(), side.r(), side.c());
    }

    public void eraseNumber(int r, int c) {
        this.number[r][c] = -3;
    }

    public void eraseNumber(Address pos) {
        this.eraseNumber(pos.r(), pos.c());
    }

    public void enterNumber(Address pos, int n) {
        if (this.getArrowNumber(pos) == n) {
            this.toggleArrowDirection(pos);
        } else {
            this.eraseLinesAround(pos);
            this.setArrowNumber(pos, n);
        }
    }

    int[][][] getState() {
        return this.state;
    }

    public int getState(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.state[d][r][c];
        }
        return -9;
    }

    public int getState(SideAddress pos) {
        return this.getState(pos.d(), pos.r(), pos.c());
    }

    public int getStateJ(Address pos, int d) {
        return this.getState(SideAddress.get(pos, d));
    }

    public void setState(int d, int r, int c, int st) {
        if (this.isSideOn(d, r, c)) {
            this.state[d][r][c] = st;
        }
    }

    public void setState(SideAddress pos, int st) {
        this.setState(pos.d(), pos.r(), pos.c(), st);
    }

    public void setStateJ(Address pos, int d, int st) {
        this.setState(SideAddress.get(pos, d), st);
    }

    public boolean isLine(int d, int r, int c) {
        if (!this.isSideOn(d, r, c)) {
            return false;
        }
        return this.state[d][r][c] == 1;
    }

    public Link getLink(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.link[d][r][c];
        }
        return null;
    }

    public Link getLink(SideAddress pos) {
        return this.link[pos.d()][pos.r()][pos.c()];
    }

    public Link getLink(int r, int c) {
        Link link = this.getLink(0, r, c - 1);
        if (link != null) {
            return link;
        }
        link = this.getLink(0, r, c);
        if (link != null) {
            return link;
        }
        link = this.getLink(1, r - 1, c);
        if (link != null) {
            return link;
        }
        link = this.getLink(1, r, c);
        if (link != null) {
            return link;
        }
        return null;
    }

    public void setLink(int d, int r, int c, Link l) {
        this.link[d][r][c] = l;
    }

    public void setLink(SideAddress pos, Link l) {
        this.link[pos.d()][pos.r()][pos.c()] = l;
    }

    public boolean hasMultipleLinks() {
        return this.linkList.size() > 1;
    }

    void eraseLinesAround(Address pos) {
        int d = 0;
        while (d <= 3) {
            SideAddress side = SideAddress.get(pos, d);
            if (this.getState(side) == 1) {
                this.changeState(side, 0);
            }
            ++d;
        }
    }

    void eraseLinesAroundA(Address pos) {
        int d = 0;
        while (d <= 3) {
            SideAddress side = SideAddress.get(pos, d);
            if (this.getState(side) == 1) {
                this.changeStateA(side, 0);
            }
            ++d;
        }
    }

    public void changeStateA(Address pos, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new PaintStep(pos.r(), pos.c(), this.getNumber(pos), st)));
        this.setNumber(pos, st);
    }

    public void changeState(int d, int r, int c, int st) {
        int previousState = this.getState(d, r, c);
        this.setState(d, r, c, st);
        if (previousState == 1) {
            this.cutLink(d, r, c);
        }
        if (st == 1) {
            this.connectLink(d, r, c);
        }
    }

    public void changeState(SideAddress pos, int st) {
        this.changeState(pos.d(), pos.r(), pos.c(), st);
    }

    public void changeStateA(SideAddress pos, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new LineStep(pos.d(), pos.r(), pos.c(), this.getState(pos), st)));
        this.changeState(pos, st);
    }

    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt3(this.state, 0);
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isNumber(r, c)) {
                    this.number[r][c] = -3;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) == -1) {
                    this.setNumber(r, c, -3);
                }
                ++c;
            }
            ++r;
        }
    }

    public void initBoard() {
        this.initLinks();
    }

    void initLinks() {
        Link.resetId();
        this.linkList.clear();
        ArrayUtil.initArrayObject2(this.link[0], null);
        ArrayUtil.initArrayObject2(this.link[1], null);
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                this.initLink(r, c);
                ++c;
            }
            ++r;
        }
    }

    boolean isBlock(int r, int c) {
        return this.isBlack(r - 1, c) || this.isBlack(r + 1, c) || this.isBlack(r, c - 1) || this.isBlack(r, c + 1);
    }

    void initLink(int r, int c) {
        this.initializingLink = new Link();
        this.initLink1(0, r, c - 1);
        this.initLink1(0, r, c);
        this.initLink1(1, r - 1, c);
        this.initLink1(1, r, c);
        if (!this.initializingLink.isEmpty()) {
            this.linkList.add(this.initializingLink);
        }
    }

    private void initLink1(int d, int r, int c) {
        if (!this.isSideOn(d, r, c)) {
            return;
        }
        if (!this.isLine(d, r, c)) {
            return;
        }
        if (this.getLink(d, r, c) != null) {
            return;
        }
        this.initializingLink.add(d, r, c);
        this.setLink(d, r, c, this.initializingLink);
        if (d == 0) {
            this.initLink1(0, r, c - 1);
            this.initLink1(0, r, c + 1);
            this.initLink1(1, r - 1, c);
            this.initLink1(1, r - 1, c + 1);
            this.initLink1(1, r, c);
            this.initLink1(1, r, c + 1);
        }
        if (d == 1) {
            this.initLink1(1, r - 1, c);
            this.initLink1(1, r + 1, c);
            this.initLink1(0, r, c - 1);
            this.initLink1(0, r + 1, c - 1);
            this.initLink1(0, r, c);
            this.initLink1(0, r + 1, c);
        }
    }

    void connectLink(int d, int r, int c) {
        Link newLink = null;
        Link link1 = null;
        Link link2 = null;
        if (d == 0) {
            link1 = this.getLink(r, c);
            link2 = this.getLink(r, c + 1);
        } else if (d == 1) {
            link1 = this.getLink(r, c);
            link2 = this.getLink(r + 1, c);
        }
        if (link1 == null && link2 == null) {
            newLink = new Link();
            this.linkList.add(newLink);
        } else if (link1 == null && link2 != null) {
            newLink = link2;
        } else if (link1 != null && link2 == null) {
            newLink = link1;
        } else if (link1 == link2) {
            newLink = link1;
        } else if (link1.size() >= link2.size()) {
            newLink = link1;
            newLink.addAll(link2);
            for (SideAddress joint : link2) {
                this.setLink(joint, newLink);
            }
            this.linkList.remove(link2);
        } else {
            newLink = link2;
            newLink.addAll(link1);
            for (SideAddress joint : link1) {
                this.setLink(joint, newLink);
            }
            this.linkList.remove(link1);
        }
        newLink.add(d, r, c);
        this.setLink(d, r, c, newLink);
    }

    void cutLink(int d, int r, int c) {
        Link oldLink = this.getLink(d, r, c);
        Link longerLink = null;
        for (SideAddress joint : oldLink) {
            this.setLink(joint, null);
        }
        this.linkList.remove(oldLink);
        if (d == 0) {
            this.initLink(r, c);
            longerLink = this.initializingLink;
            this.initLink(r, c + 1);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
        } else if (d == 1) {
            this.initLink(r, c);
            longerLink = this.initializingLink;
            this.initLink(r + 1, c);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
        }
        longerLink.setId(oldLink.getId());
    }

    public int countLine(int r, int c) {
        int no = 0;
        if (r < this.rows() - 1 && this.isLine(1, r, c)) {
            ++no;
        }
        if (c < this.cols() - 1 && this.isLine(0, r, c)) {
            ++no;
        }
        if (r > 0 && this.isLine(1, r - 1, c)) {
            ++no;
        }
        if (c > 0 && this.isLine(0, r, c - 1)) {
            ++no;
        }
        return no;
    }

    boolean isBranchedLink(int d, int r, int c) {
        if (this.countLine(r, c) > 2) {
            return true;
        }
        return d == 0 ? this.countLine(r, c + 1) > 2 : d == 1 && this.countLine(r + 1, c) > 2;
    }

    boolean isBuriedLink(int d, int r, int c) {
        return d == 0 ? this.isBlack(r, c) || this.isBlack(r, c + 1) : d == 1 && (this.isBlack(r, c) || this.isBlack(r + 1, c));
    }

    private int checkLinks() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                int l = this.countLine(r, c);
                if (l > 2) {
                    result |= 1;
                } else if (l == 1) {
                    result |= 2;
                }
                if (this.isBlack(r, c) && l > 0) {
                    result |= 0x40;
                }
                if (!this.isNumber(r, c) && !this.isBlack(r, c) && l == 0) {
                    result |= 8;
                }
                ++c;
            }
            ++r;
        }
        if (this.hasMultipleLinks()) {
            result |= 4;
        }
        return result;
    }

    private int checkArrows() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) >= 0) {
                    result |= this.checkArrow(r, c);
                }
                if (this.isBlack(r, c) && this.isBlock(r, c)) {
                    result |= 0x20;
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    int checkArrow(int r, int c) {
        int result = 0;
        int blackCount = 0;
        int dir = this.getArrowDirection(r, c);
        int number = this.getArrowNumber(r, c);
        Address pos = new Address(r, c);
        pos.move(dir);
        while (this.isOn(pos)) {
            if (this.isBlack(pos.r(), pos.c())) {
                ++blackCount;
            }
            pos.move(dir);
        }
        result = number == blackCount ? 0 : 16;
        return result;
    }

    public int checkAnswerCode() {
        int result = 0;
        result |= this.checkLinks();
        return result |= this.checkArrows();
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("Board.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("Board.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("Board.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("Board.AnswerCheckMessage4"));
        }
        if ((result & 0x40) == 64) {
            message.append(Messages.getString("Board.AnswerCheckMessage7"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("Board.AnswerCheckMessage6"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("Board.AnswerCheckMessage5"));
        }
        return message.toString();
    }

    class LineStep
    extends Step {
        private int direction;
        private int row;
        private int col;
        private int before;
        private int after;

        public LineStep(int d, int r, int c, int b, int a) {
            this.direction = d;
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.direction, this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.direction, this.row, this.col, this.after);
        }
    }

    class PaintStep
    extends Step {
        private int row;
        private int col;
        private int before;
        private int after;

        public PaintStep(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.setNumber(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.setNumber(this.row, this.col, this.after);
        }
    }

    class Step
    extends AbstractUndoableEdit {
        Step() {
        }
    }
}

