/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.fillomino;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.fillomino.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int state;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftPressed(Address pos) {
        this.state = this.board.getNumber(pos);
    }

    protected void rightPressed(Address pos) {
        if (!this.board.isStable(pos)) {
            this.board.enterNumberA(pos, 0);
        }
    }

    protected void leftClicked(Address pos) {
        if (!this.board.isStable(pos)) {
            int n = this.board.getNumber(pos);
            this.board.enterNumberA(pos, n + 1);
        }
    }

    protected void rightClicked(Address pos) {
        int n;
        if (!this.board.isStable(pos) && (n = this.board.getNumber(pos)) > 0) {
            this.board.enterNumberA(pos, n - 1);
        }
    }

    protected void leftDragged(Address oldPos, Address pos) {
        if (!this.board.isStable(pos)) {
            this.board.enterNumberA(pos, this.state);
        }
    }

    protected void rightDragged(Address oldPos, Address pos) {
        if (!this.board.isStable(pos)) {
            this.board.enterNumberA(pos, 0);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode()) {
            if (num > 0) {
                Address posS;
                this.board.changeNumber(pos, num);
                this.board.setState(pos, 1);
                if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && !this.board.isStable(posS)) {
                    this.board.setState(posS, 1);
                    this.board.changeNumber(posS, 0);
                }
            }
        } else if (this.isCursorOn() && num >= 0 && !this.board.isStable(pos)) {
            this.board.enterNumberA(pos, num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, 0);
            this.board.setState(pos, 0);
            if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && this.board.isStable(posS)) {
                this.board.setState(posS, 0);
                this.board.changeNumber(posS, 0);
            }
        } else if (this.isCursorOn() && !this.board.isStable(pos)) {
            this.board.enterNumberA(pos, 0);
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.changeNumber(pos, 0);
            this.board.setState(pos, 1);
            if (this.isSymmetricPlacementMode() && !(posS = this.getSymmetricPosition(pos)).equals(pos) && !this.board.isStable(posS)) {
                this.board.setState(posS, 1);
                this.board.changeNumber(posS, 0);
            }
        }
    }
}

