/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.DigitPatternHint;
import pencilbox.hakyukoka.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Board
extends BoardBase {
    static final int UNSTABLE = 0;
    static final int STABLE = 1;
    static final int UNKNOWN = 0;
    private List<Area> areaList;
    private int[][] state;
    private int[][] number;
    private Area[][] area;
    private int[][] multi;
    private int[][] multi2;
    private DigitPatternHint hint;

    @Override
    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.number = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList<Area>();
        this.multi = new int[this.rows()][this.cols()];
        this.multi2 = new int[this.rows()][this.cols()];
        this.hint = new DigitPatternHint();
        this.hint.setupHint(this);
    }

    @Override
    public void clearBoard() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isStable(r, c)) {
                    this.number[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    public boolean isStable(int r, int c) {
        return this.state[r][c] == 1;
    }

    public boolean isStable(Address pos) {
        return this.isStable(pos.r(), pos.c());
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public int getState(Address pos) {
        return this.getState(pos.r(), pos.c());
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public void setState(Address pos, int st) {
        this.setState(pos.r(), pos.c(), st);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public boolean isUnknown(int r, int c) {
        return this.number[r][c] == 0;
    }

    public Area getArea(int r, int c) {
        return this.area[r][c];
    }

    public Area getArea(Address pos) {
        return this.getArea(pos.r(), pos.c());
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public boolean isError(int r, int c) {
        return this.isTooClose(r, c) || this.isMultipleNumber(r, c) || this.isTooLarge(r, c);
    }

    public boolean isTooClose(int r, int c) {
        return this.multi[r][c] > 1;
    }

    public boolean isMultipleNumber(int r, int c) {
        return this.multi2[r][c] > 1;
    }

    public boolean isTooLarge(int r, int c) {
        return this.getArea(r, c) != null && this.getNumber(r, c) > this.getArea(r, c).size();
    }

    int getPattern(int r, int c) {
        return this.hint.getPattern(r, c);
    }

    boolean canPlace(int r, int c, int n) {
        return this.hint.canPlace(r, c, n);
    }

    public void changeNumber(int r, int c, int n) {
        if (this.getNumber(r, c) == n) {
            return;
        }
        int prevNum = this.getNumber(r, c);
        this.updateMulti(r, c, n);
        if (this.getArea(r, c) != null) {
            this.updateMulti2(r, c, n);
        }
        this.setNumber(r, c, n);
        if (prevNum == 0 && n > 0) {
            this.hint.checkUsedNumber(r, c, n);
        } else {
            this.hint.initHint();
        }
    }

    public void changeNumber(Address pos, int n) {
        this.changeNumber(pos.r(), pos.c(), n);
    }

    public void enterNumberA(Address pos, int n) {
        if (n < 0) {
            return;
        }
        if (n == this.getNumber(pos)) {
            return;
        }
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(pos.r(), pos.c(), this.getNumber(pos), n)));
        this.changeNumber(pos, n);
    }

    public void addArea(Area newArea) {
        for (Address pos : newArea) {
            this.area[pos.r()][pos.c()] = newArea;
        }
        this.areaList.add(newArea);
    }

    public void removeArea(Area oldArea) {
        for (Address pos : oldArea) {
            if (this.area[pos.r()][pos.c()] != oldArea) continue;
            this.area[pos.r()][pos.c()] = null;
        }
        this.areaList.remove(oldArea);
    }

    public void addCellToArea(int r, int c, Area area) {
        if (area.isEmpty()) {
            this.areaList.add(area);
        }
        this.setArea(r, c, area);
        area.add(r, c);
    }

    public void addCellToArea(Address pos, Area area) {
        this.addCellToArea(pos.r(), pos.c(), area);
    }

    public void removeCellFromArea(int r, int c, Area area) {
        this.setArea(r, c, null);
        area.remove(r, c);
        if (area.isEmpty()) {
            this.areaList.remove(area);
        }
    }

    public void removeCellFromArea(Address pos, Area area) {
        this.removeCellFromArea(pos.r(), pos.c(), area);
    }

    List<Area> getAreaList() {
        return this.areaList;
    }

    int[][] getNumber() {
        return this.number;
    }

    int[][] getState() {
        return this.state;
    }

    @Override
    public void initBoard() {
        this.initMulti();
        this.initMulti2();
        this.hint.initHint();
    }

    void initMulti() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) > 0) {
                    this.initMulti1(r, c, this.getNumber(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    private void initMulti1(int r0, int c0, int num) {
        this.multi[r0][c0] = 1;
        int c = c0 - num;
        while (c <= c0 + num) {
            if (c != c0 && this.isOn(r0, c) && this.getNumber(r0, c) == num) {
                int[] nArray = this.multi[r0];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++c;
        }
        int r = r0 - num;
        while (r <= r0 + num) {
            if (r != r0 && this.isOn(r, c0) && this.getNumber(r, c0) == num) {
                int[] nArray = this.multi[r0];
                int n = c0;
                nArray[n] = nArray[n] + 1;
            }
            ++r;
        }
    }

    void updateMulti(int r0, int c0, int num) {
        int r;
        int c;
        int prevNum = this.getNumber(r0, c0);
        if (this.multi[r0][c0] > 1) {
            c = c0 - prevNum;
            while (c <= c0 + prevNum) {
                if (c != c0 && this.isOn(r0, c) && this.getNumber(r0, c) == prevNum) {
                    int[] nArray = this.multi[r0];
                    int n = c;
                    nArray[n] = nArray[n] - 1;
                }
                ++c;
            }
            r = r0 - prevNum;
            while (r <= r0 + prevNum) {
                if (r != r0 && this.isOn(r, c0) && this.getNumber(r, c0) == prevNum) {
                    int[] nArray = this.multi[r];
                    int n = c0;
                    nArray[n] = nArray[n] - 1;
                }
                ++r;
            }
        }
        if (num == 0) {
            this.multi[r0][c0] = 0;
        } else if (num > 0) {
            this.multi[r0][c0] = 1;
            c = c0 - num;
            while (c <= c0 + num) {
                if (c != c0 && this.isOn(r0, c) && this.getNumber(r0, c) == num) {
                    int[] nArray = this.multi[r0];
                    int n = c;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray2 = this.multi[r0];
                    int n2 = c0;
                    nArray2[n2] = nArray2[n2] + 1;
                }
                ++c;
            }
            r = r0 - num;
            while (r <= r0 + num) {
                if (r != r0 && this.isOn(r, c0) && this.getNumber(r, c0) == num) {
                    int[] nArray = this.multi[r];
                    int n = c0;
                    nArray[n] = nArray[n] + 1;
                    int[] nArray3 = this.multi[r0];
                    int n3 = c0;
                    nArray3[n3] = nArray3[n3] + 1;
                }
                ++r;
            }
        }
    }

    void initMulti2() {
        int r = this.rows() - 1;
        while (r >= 0) {
            int c = this.cols() - 1;
            while (c >= 0) {
                if (this.getNumber(r, c) > 0 && this.getArea(r, c) != null) {
                    this.initMulti21(r, c, this.getNumber(r, c));
                }
                --c;
            }
            --r;
        }
    }

    private void initMulti21(int r0, int c0, int num) {
        this.multi2[r0][c0] = 1;
        for (Address pos : this.getArea(r0, c0)) {
            if (pos.equals(r0, c0) || this.getNumber(pos.r(), pos.c()) != num) continue;
            int[] nArray = this.multi2[r0];
            int n = c0;
            nArray[n] = nArray[n] + 1;
        }
    }

    void updateMulti2(int r0, int c0, int num) {
        int prevNum = this.getNumber(r0, c0);
        if (this.multi2[r0][c0] > 1) {
            for (Address pos : this.getArea(r0, c0)) {
                if (pos.equals(r0, c0) || this.getNumber(pos.r(), pos.c()) != prevNum) continue;
                int[] nArray = this.multi2[pos.r()];
                int n = pos.c();
                nArray[n] = nArray[n] - 1;
            }
        }
        if (num == 0) {
            this.multi2[r0][c0] = 0;
        } else if (num > 0) {
            this.multi2[r0][c0] = 1;
            for (Address pos : this.getArea(r0, c0)) {
                if (pos.equals(r0, c0) || this.getNumber(pos.r(), pos.c()) != num) continue;
                int[] nArray = this.multi2[pos.r()];
                int n = pos.c();
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = this.multi2[r0];
                int n2 = c0;
                nArray2[n2] = nArray2[n2] + 1;
            }
        }
    }

    @Override
    public int checkAnswerCode() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getNumber(r, c) > 0 && this.isMultipleNumber(r, c)) {
                    result |= 2;
                }
                if (this.isTooLarge(r, c)) {
                    result |= 4;
                }
                if (this.isTooClose(r, c)) {
                    result |= 8;
                }
                if (this.isUnknown(r, c)) {
                    result |= 1;
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    @Override
    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        if (result == 1) {
            return Messages.getString("Board.AnswerCheckMessage1");
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2) {
            message.append(Messages.getString("Board.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("Board.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("Board.AnswerCheckMessag4"));
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (Board.this.isStable(this.row, this.col)) {
                return;
            }
            Board.this.changeNumber(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (Board.this.isStable(this.row, this.col)) {
                return;
            }
            Board.this.changeNumber(this.row, this.col, this.after);
        }

        public boolean addEdit(UndoableEdit anEdit) {
            Step edit = (Step)anEdit;
            if (edit.row == this.row && edit.col == this.col) {
                this.after = edit.after;
                return true;
            }
            return false;
        }
    }
}

