/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slalom;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.slalom.Messages;
import pencilbox.slalom.Panel;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem wallColorItem;
    private JMenuItem lineColorItem;
    private JMenuItem gateColorItem;
    private JMenuItem crossColorItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem separateLinkColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        super.buildViewMenu();
        this.wallColorItem = this.addColorMenuItem(Messages.getString("Menu.wallColorItem"));
        this.numberColorItem = this.addColorMenuItem(Messages.getString("Menu.numberColorItem"));
        this.gateColorItem = this.addColorMenuItem(Messages.getString("Menu.gateColorItem"));
        this.lineColorItem = this.addColorMenuItem(Messages.getString("Menu.lineColorItem"));
        this.crossColorItem = this.addColorMenuItem(Messages.getString("Menu.crossColorItem"));
        this.separateLinkColorItem = this.makeCheckBoxCommandMenuItem(Messages.getString("Menu.separateLinkColorItem"), 'R', false);
        this.addToViewMenu(this.separateLinkColorItem);
        this.addRenewColorMenuItem();
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.separateLinkColorItem) {
            this.getPanel().setSeparateLinkColorMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.lineColorItem) {
            return this.getPanel().getLineColor();
        }
        if (target == this.crossColorItem) {
            return this.getPanel().getCrossColor();
        }
        if (target == this.gateColorItem) {
            return this.getPanel().getGateColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        if (target == this.wallColorItem) {
            return this.getPanel().getWallColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.lineColorItem) {
            this.getPanel().setLineColor(color);
        } else if (target == this.crossColorItem) {
            this.getPanel().setCrossColor(color);
        } else if (target == this.gateColorItem) {
            this.getPanel().setGateColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else if (target == this.wallColorItem) {
            this.getPanel().setWallColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.separateLinkColorItem.setSelected(this.getPanel().isSeparateLinkColorMode());
    }
}

