/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.slalom;

import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.core.SideAddress;
import pencilbox.slalom.Link;
import pencilbox.slalom.Messages;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int HORIZ = 1;
    static final int VERT = 0;
    static final int UNKNOWN = 0;
    static final int LINE = 1;
    static final int NOLINE = -1;
    static final int BLANK = -3;
    static final int GOAL = -1;
    static final int OUTER = -9;
    static final int UNDECIDED_NUMBER = 0;
    static final int GATE_VERT = -5;
    static final int GATE_HORIZ = -4;
    private int[][] number;
    private int[][][] state;
    private int[][] gateNumber;
    private int nGate;
    private Address goal;
    private List<Link> linkList;
    private Link[][][] link;
    private Link initializingLink;

    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.gateNumber = new int[this.rows()][this.cols()];
        ArrayUtil.initArrayInt2(this.number, -3);
        this.goal = new Address(-1, -1);
        this.state = new int[2][][];
        this.state[0] = new int[this.rows()][this.cols() - 1];
        this.state[1] = new int[this.rows() - 1][this.cols()];
        this.linkList = new LinkedList<Link>();
        this.link = new Link[2][][];
        this.link[0] = new Link[this.rows()][this.cols() - 1];
        this.link[1] = new Link[this.rows() - 1][this.cols()];
    }

    public void setNumber(int r, int c, int n) {
        int n0 = this.number[r][c];
        if (n0 == -1) {
            this.goal.setNowhere();
        }
        if (n == -1) {
            if (!this.goal.isNowhere()) {
                this.number[this.goal.r()][this.goal.c()] = -3;
            }
            this.goal.set(r, c);
        }
        this.number[r][c] = n;
    }

    public void setNumber(Address pos, int n) {
        this.setNumber(pos.r(), pos.c(), n);
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public int getNumber(Address pos) {
        return this.getNumber(pos.r(), pos.c());
    }

    public boolean isWall(int r, int c) {
        return this.number[r][c] >= 0 || this.number[r][c] == 0;
    }

    public boolean isWall(Address pos) {
        return this.isWall(pos.r(), pos.c());
    }

    public boolean isGate(int r, int c) {
        return this.number[r][c] == -4 || this.number[r][c] == -5;
    }

    public boolean isGate(Address pos) {
        return this.isGate(pos.r(), pos.c());
    }

    public boolean hasWall(int d, int r, int c) {
        if (d == 0) {
            return this.isWall(r, c) || this.isWall(r, c + 1);
        }
        if (d == 1) {
            return this.isWall(r, c) || this.isWall(r + 1, c);
        }
        return false;
    }

    public boolean hasWall(SideAddress pos) {
        return this.hasWall(pos.d(), pos.r(), pos.c());
    }

    public int getGateNumber(Address p) {
        return this.gateNumber[p.r()][p.c()];
    }

    public int getGateNumber(int r, int c) {
        return this.gateNumber[r][c];
    }

    public int setGateNumber(Address p, int n) {
        int n2 = n;
        this.gateNumber[p.r()][p.c()] = n2;
        return n2;
    }

    public int setGateNumber(int r, int c, int n) {
        int n2 = n;
        this.gateNumber[r][c] = n2;
        return n2;
    }

    public int getNGate() {
        return this.nGate;
    }

    public int getState(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.state[d][r][c];
        }
        return -9;
    }

    public int getState(SideAddress pos) {
        return this.getState(pos.d(), pos.r(), pos.c());
    }

    public int getStateJ(Address pos, int d) {
        return this.getState(SideAddress.get(pos, d));
    }

    public void setState(int d, int r, int c, int st) {
        if (this.isSideOn(d, r, c)) {
            this.state[d][r][c] = st;
        }
    }

    public void setState(SideAddress pos, int st) {
        this.setState(pos.d(), pos.r(), pos.c(), st);
    }

    public void setStateJ(Address pos, int d, int st) {
        this.setState(SideAddress.get(pos, d), st);
    }

    public boolean isLine(int d, int r, int c) {
        if (!this.isSideOn(d, r, c)) {
            return false;
        }
        return this.state[d][r][c] == 1;
    }

    public Link getLink(int d, int r, int c) {
        if (this.isSideOn(d, r, c)) {
            return this.link[d][r][c];
        }
        return null;
    }

    public Link getLink(SideAddress pos) {
        return this.link[pos.d()][pos.r()][pos.c()];
    }

    public Link getLink(int r, int c) {
        Link link = this.getLink(0, r, c - 1);
        if (link != null) {
            return link;
        }
        link = this.getLink(0, r, c);
        if (link != null) {
            return link;
        }
        link = this.getLink(1, r - 1, c);
        if (link != null) {
            return link;
        }
        link = this.getLink(1, r, c);
        if (link != null) {
            return link;
        }
        return null;
    }

    public void setLink(int d, int r, int c, Link l) {
        this.link[d][r][c] = l;
    }

    public void setLink(SideAddress pos, Link l) {
        this.link[pos.d()][pos.r()][pos.c()] = l;
    }

    void eraseLinesAround(Address pos) {
        int d = 0;
        while (d <= 3) {
            SideAddress side = SideAddress.get(pos, d);
            if (this.getState(side) == 1 || this.getState(side) == -1) {
                this.changeStateA(side, 0);
            }
            ++d;
        }
    }

    public void changeState(int d, int r, int c, int st) {
        int previousState = this.getState(d, r, c);
        this.setState(d, r, c, st);
        if (previousState == 1) {
            this.cutLink(d, r, c);
        }
        if (st == 1) {
            this.connectLink(d, r, c);
        }
    }

    public void changeState(SideAddress pos, int st) {
        this.changeState(pos.d(), pos.r(), pos.c(), st);
    }

    public void changeStateA(SideAddress pos, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(pos.d(), pos.r(), pos.c(), this.getState(pos), st)));
        this.changeState(pos, st);
    }

    public void clearBoard() {
        super.clearBoard();
        ArrayUtil.initArrayInt3(this.state, 0);
        this.initBoard();
    }

    public void trimAnswer() {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.rows()) {
                int c = 0;
                while (c < this.cols()) {
                    if (this.getState(d, r, c) == -1) {
                        this.setState(d, r, c, 0);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
    }

    public void initBoard() {
        this.initGates();
        this.initLinks();
    }

    void initGates() {
        int n;
        int c;
        this.nGate = 0;
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                this.setGateNumber(r, c, 0);
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                n = this.getNumber(r, c);
                if (n == -1) {
                    this.goal.set(r, c);
                } else if (n == -4) {
                    if (!this.isOn(r, c - 1) || this.getNumber(r, c - 1) != -4) {
                        ++this.nGate;
                    }
                } else if (!(n != -5 || this.isOn(r - 1, c) && this.getNumber(r - 1, c) == -5)) {
                    ++this.nGate;
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                n = this.getNumber(r, c);
                if (n > 0) {
                    this.initGateNumber(r, c, n);
                }
                ++c;
            }
            ++r;
        }
    }

    private Address getAnotherPole(Address p0, int d) {
        Address p;
        block4: {
            p = new Address(p0);
            int gateType = 0;
            if (d == 0 || d == 2) {
                gateType = -5;
            } else if (d == 1 || d == 3) {
                gateType = -4;
            }
            do {
                p.move(d);
                if (!this.isOn(p)) break block4;
                if (!this.isWall(p)) continue;
                return p;
            } while (this.getNumber(p) == gateType);
            return null;
        }
        return p;
    }

    private void setGateNumber(int r, int c, int d, int n) {
        Address p = new Address(r, c);
        int t = 0;
        t = d == 0 || d == 2 ? -5 : -4;
        p.set(r, c);
        while (true) {
            p.move(d);
            if (!this.isOn(p) || this.getNumber(p) != t) break;
            this.setGateNumber(p, n);
        }
    }

    private void initGateNumber(int r, int c, int n0) {
        Address p = new Address(r, c);
        Address p1 = null;
        int d1 = -1;
        int ng = 0;
        int count = 0;
        int d = 0;
        while (d <= 3) {
            int t = 0;
            t = d == 0 || d == 2 ? -5 : -4;
            p.set(r, c);
            p.move(d);
            if (this.isOn(p) && this.getNumber(p) == t) {
                d1 = d;
                ++count;
                p1 = this.getAnotherPole(p, d);
                if (p1 != null && this.isOn(p1)) {
                    int n1 = this.getNumber(p1);
                    if (n1 == n0) {
                        ng = n1;
                        this.setGateNumber(r, c, d, n1);
                    } else if (n1 > 0 && n1 != n0) {
                        ng = -1;
                        this.setGateNumber(r, c, d, -1);
                    }
                }
            }
            ++d;
        }
        if (count != 0 && count == 1) {
            if (ng == 0) {
                this.setGateNumber(r, c, d1, n0);
            } else if (ng != -1) {
                // empty if block
            }
        }
    }

    void initLinks() {
        Link.resetId();
        this.linkList.clear();
        ArrayUtil.initArrayObject2(this.link[0], null);
        ArrayUtil.initArrayObject2(this.link[1], null);
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                this.initLink(r, c);
                ++c;
            }
            ++r;
        }
    }

    void initLink(int r, int c) {
        this.initializingLink = new Link();
        this.initLink1(0, r, c - 1);
        this.initLink1(0, r, c);
        this.initLink1(1, r - 1, c);
        this.initLink1(1, r, c);
        if (!this.initializingLink.isEmpty()) {
            this.linkList.add(this.initializingLink);
        }
    }

    private void initLink1(int d, int r, int c) {
        if (!this.isSideOn(d, r, c)) {
            return;
        }
        if (!this.isLine(d, r, c)) {
            return;
        }
        if (this.getLink(d, r, c) != null) {
            return;
        }
        this.initializingLink.add(d, r, c);
        this.setLink(d, r, c, this.initializingLink);
        if (d == 0) {
            this.initLink1(0, r, c - 1);
            this.initLink1(0, r, c + 1);
            this.initLink1(1, r - 1, c);
            this.initLink1(1, r - 1, c + 1);
            this.initLink1(1, r, c);
            this.initLink1(1, r, c + 1);
        }
        if (d == 1) {
            this.initLink1(1, r - 1, c);
            this.initLink1(1, r + 1, c);
            this.initLink1(0, r, c - 1);
            this.initLink1(0, r + 1, c - 1);
            this.initLink1(0, r, c);
            this.initLink1(0, r + 1, c);
        }
    }

    void connectLink(int d, int r, int c) {
        Link newLink = null;
        Link link1 = null;
        Link link2 = null;
        if (d == 0) {
            link1 = this.getLink(r, c);
            link2 = this.getLink(r, c + 1);
        } else if (d == 1) {
            link1 = this.getLink(r, c);
            link2 = this.getLink(r + 1, c);
        }
        if (link1 == null && link2 == null) {
            newLink = new Link();
            this.linkList.add(newLink);
        } else if (link1 == null && link2 != null) {
            newLink = link2;
        } else if (link1 != null && link2 == null) {
            newLink = link1;
        } else if (link1 == link2) {
            newLink = link1;
        } else if (link1.size() >= link2.size()) {
            newLink = link1;
            newLink.addAll(link2);
            for (SideAddress joint : link2) {
                this.setLink(joint, newLink);
            }
            this.linkList.remove(link2);
        } else {
            newLink = link2;
            newLink.addAll(link1);
            for (SideAddress joint : link1) {
                this.setLink(joint, newLink);
            }
            this.linkList.remove(link1);
        }
        newLink.add(d, r, c);
        this.setLink(d, r, c, newLink);
    }

    void cutLink(int d, int r, int c) {
        Link oldLink = this.getLink(d, r, c);
        Link longerLink = null;
        for (SideAddress joint : oldLink) {
            this.setLink(joint, null);
        }
        this.linkList.remove(oldLink);
        if (d == 0) {
            this.initLink(r, c);
            longerLink = this.initializingLink;
            this.initLink(r, c + 1);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
        } else if (d == 1) {
            this.initLink(r, c);
            longerLink = this.initializingLink;
            this.initLink(r + 1, c);
            if (this.initializingLink.size() > longerLink.size()) {
                longerLink = this.initializingLink;
            }
        }
        longerLink.setId(oldLink.getId());
    }

    public int countLine(int r, int c) {
        int no = 0;
        if (r < this.rows() - 1 && this.isLine(1, r, c)) {
            ++no;
        }
        if (c < this.cols() - 1 && this.isLine(0, r, c)) {
            ++no;
        }
        if (r > 0 && this.isLine(1, r - 1, c)) {
            ++no;
        }
        if (c > 0 && this.isLine(0, r, c - 1)) {
            ++no;
        }
        return no;
    }

    boolean isBranchedLink(int d, int r, int c) {
        if (this.countLine(r, c) > 2) {
            return true;
        }
        return d == 0 ? this.countLine(r, c + 1) > 2 : d == 1 && this.countLine(r + 1, c) > 2;
    }

    private int checkLinks() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                int l = this.countLine(r, c);
                if (l > 2) {
                    result |= 1;
                } else if (l == 1) {
                    result |= 2;
                }
                ++c;
            }
            ++r;
        }
        if (this.linkList.size() > 1) {
            result |= 4;
        } else if (this.linkList.size() == 0) {
            result |= 8;
        }
        return result;
    }

    private int checkGates() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isGate(r, c)) {
                    int ret = this.checkGate1(r, c);
                    if (ret == -1) {
                        return 16;
                    }
                    if (ret == 0) {
                        return 32;
                    }
                    if (ret > 1) {
                        return 64;
                    }
                }
                ++c;
            }
            ++r;
        }
        return 0;
    }

    private int checkGate1(int r, int c) {
        int count = 0;
        int gateType = this.getNumber(r, c);
        Address p = new Address(r, c);
        int d = 0;
        if (gateType == -4) {
            d = 3;
            p.set(r, c - 1);
        } else if (gateType == -5) {
            d = 2;
            p.set(r - 1, c);
        }
        if (this.isOn(p) && this.getNumber(p) == gateType) {
            return -2;
        }
        p.set(r, c);
        do {
            int ret;
            if ((ret = this.checkGate2(p)) == -1) {
                return -1;
            }
            if (ret == 1) {
                ++count;
            }
            p.move(d);
        } while (this.isOn(p) && this.getNumber(p) == gateType);
        return count;
    }

    private int checkGate2(Address p) {
        int type = this.getNumber(p);
        if (type == -5) {
            if (this.getStateJ(p, 0) == 1 || this.getStateJ(p, 2) == 1) {
                return -1;
            }
            if (this.getStateJ(p, 1) == 1 && this.getStateJ(p, 3) == 1) {
                return 1;
            }
        } else if (type == -4) {
            if (this.getStateJ(p, 1) == 1 || this.getStateJ(p, 3) == 1) {
                return -1;
            }
            if (this.getStateJ(p, 0) == 1 && this.getStateJ(p, 2) == 1) {
                return 1;
            }
        }
        return 0;
    }

    private int checkRoute() {
        Address p0;
        int[] gateNumber = new int[this.nGate];
        int k = 0;
        if (this.goal.isNowhere()) {
            p0 = this.\uff54emporalGoal();
        } else {
            p0 = new Address(this.goal);
            if (this.getLink(p0.r(), p0.c()) == null) {
                return 512;
            }
        }
        Address p = new Address(p0);
        int d = -1;
        do {
            d = this.getLineDirection(p, d);
            p.move(d);
            if (!this.isGate(p)) continue;
            gateNumber[k] = this.getGateNumber(p);
            if (++k <= this.nGate) continue;
            return 128;
        } while (!p.equals(p0));
        if (k < this.nGate) {
            return 128;
        }
        int gg = 1;
        if (this.goal.isNowhere() && this.nGate >= 1) {
            gg = this.nGate;
        }
        int g = 0;
        while (g < gg) {
            k = 0;
            while (k < this.nGate) {
                if (gateNumber[k] > 0 && gateNumber[k] != (k + g) % this.nGate + 1) break;
                ++k;
            }
            if (k == this.nGate) {
                return 0;
            }
            ++g;
        }
        g = 0;
        while (g < gg) {
            k = 0;
            while (k < this.nGate) {
                if (gateNumber[k] > 0 && gateNumber[k] != (this.nGate - 1 - k + g) % this.nGate + 1) break;
                ++k;
            }
            if (k == this.nGate) {
                return 0;
            }
            ++g;
        }
        return 256;
    }

    private Address \uff54emporalGoal() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.countLine(r, c) > 1) {
                    return new Address(r, c);
                }
                ++c;
            }
            ++r;
        }
        return Address.NOWEHER;
    }

    private int getLineDirection(Address p, int direction) {
        if (this.getStateJ(p, 0) == 1 && direction != 2) {
            return 0;
        }
        if (this.getStateJ(p, 1) == 1 && direction != 3) {
            return 1;
        }
        if (this.getStateJ(p, 2) == 1 && direction != 0) {
            return 2;
        }
        if (this.getStateJ(p, 3) == 1 && direction != 1) {
            return 3;
        }
        return -1;
    }

    public int checkAnswerCode() {
        int result = 0;
        result |= this.checkLinks();
        if ((result |= this.checkGates()) == 0) {
            result |= this.checkRoute();
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return COMPLETE_MESSAGE;
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(Messages.getString("Board.AnswerCheckMessage1"));
        }
        if ((result & 2) == 2) {
            message.append(Messages.getString("Board.AnswerCheckMessage2"));
        }
        if ((result & 4) == 4) {
            message.append(Messages.getString("Board.AnswerCheckMessage3"));
        }
        if ((result & 8) == 8) {
            message.append(Messages.getString("Board.AnswerCheckMessage4"));
        }
        if ((result & 0x10) == 16) {
            message.append(Messages.getString("Board.AnswerCheckMessage5"));
        }
        if ((result & 0x20) == 32) {
            message.append(Messages.getString("Board.AnswerCheckMessage6"));
        }
        if ((result & 0x40) == 64) {
            message.append(Messages.getString("Board.AnswerCheckMessage7"));
        }
        if ((result & 0x100) == 256) {
            message.append(Messages.getString("Board.AnswerCheckMessage8"));
        }
        if ((result & 0x200) == 512) {
            message.append(Messages.getString("Board.AnswerCheckMessage9"));
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int direction;
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int d, int r, int c, int b, int a) {
            this.direction = d;
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.direction, this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.direction, this.row, this.col, this.after);
        }
    }
}

