package pencilbox.heyawake;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;


/**
 *  uւ킯v}EX^L[쏈NX
 */
public class PanelEventHandler extends PanelEventHandlerBase {

	private Board board;

	private int pivotR = -1;  // hbOɌŒ肷钸_̍sW
	private int pivotC = -1;  // hbOɌŒ肷钸_̗W
//	private Square draggingSquare; // hbOč܂ɕ`ƂĂlp

	/**
	 * 
	 */
	public PanelEventHandler() {
	}

	protected void setBoard(BoardBase aBoard) {
		board = (Board) aBoard; 
	}

	protected int getMaxInputNumber() {
		Address pos = getCellCursor().getPosition();
		Square square = board.getSquare(pos.r(), pos.c());
		if (square != null)
			return square.mx();
		return 0;
	}
	/*
	 * uւ킯v}EX
	 */
	private int currentState = Board.UNKNOWN;

	protected void leftPressed(Address pos) {
		if (isProblemEditMode()) {
			Square draggingSquare;
			Square sq = board.getSquare(pos);
			if (sq == null) {
				draggingSquare = new Square(pos.r(), pos.c(), pos.r(), pos.c());
			} else {
				draggingSquare = new Square(sq);
			}
			fixPivot(draggingSquare, pos.r(), pos.c());
			setDraggingSquare(draggingSquare);
		} else {
			board.toggleState(pos.r(), pos.c(), Board.BLACK);
			currentState = board.getState(pos.r(), pos.c());
		}
	}
	
	protected void leftDragged(Address pos) {
		if (isProblemEditMode()) {
			Square draggingSquare = getDraggingSquare();
			if (draggingSquare == null) {
				return;
			}
			if (pivotR >= 0 && pivotC >= 0) {
				draggingSquare.set(pivotR, pivotC, pos.r(), pos.c());
			} else if (pivotR >= 0 && pivotC == -1) {
				draggingSquare.set(pivotR, draggingSquare.c0(), pos.r(), draggingSquare.c1());
			} else if (pivotR == -1 && pivotC >= 0) {
				draggingSquare.set(draggingSquare.r0(), pivotC, draggingSquare.r1(), pos.c());
			} else if (pivotR == -1 && pivotC == -1) {
//				draggingSquare.set(draggingSquare.r0, draggingSquare.c0, draggingSquare.r1, drggingSquare.c1());
			}
			fixPivot(draggingSquare, pos.r(), pos.c());
		} else {
			int st = board.getState(pos.r(), pos.c());
			if (st == currentState)
				return;
			if (currentState == Board.BLACK && board.isBlock(pos.r(), pos.c()))
				return;
			board.changeStateA(pos.r(), pos.c(), currentState);
		}
	}
	
	private void fixPivot(Square s, int r, int c) {
		if (pivotR == -1) {
			if (r == s.r0()) {
				pivotR = s.r1();
			} else if (r == s.r1()) {
				pivotR = s.r0();
			}
		}
		if (pivotC == -1) {
			if (c == s.c0()) {
				pivotC = s.c1();
			} else if (c == s.c1()) {
				pivotC = s.c0();
			}
		}
	}
	
	protected void leftDragFixed(Address pos) {
		if (isProblemEditMode()) {
			Square draggingSquare = getDraggingSquare();
			if (draggingSquare == null)
				return;
			int rp = pivotR >= 0 ? pivotR : draggingSquare.r0(); 
			int cp = pivotC >= 0 ? pivotC : draggingSquare.c0(); 
			Square sq = board.getSquare(rp, cp);
			if (sq == null) {
				board.removeOverlappedSquares(draggingSquare, null);
				board.addSquare(new Square(draggingSquare));
			} else {
				if (sq.r0() == draggingSquare.r0() && sq.c0() == draggingSquare.c0() && sq.r1() == draggingSquare.r1() && sq.c1() == draggingSquare.c1()) {
					;
				} else {
					board.removeOverlappedSquares(draggingSquare, sq);
					board.changeSquare(sq, draggingSquare);
				}
			}
			setDraggingSquare(null);
			resetPivot();
		}
	}
	
	protected void dragFailed() {
		setDraggingSquare(null);
		resetPivot();
	}

	protected void rightPressed(Address pos) {
		if (isProblemEditMode()) {
			Square sq = board.getSquare(pos);
			if (sq != null)
				board.removeSquare(sq);
		} else {
			board.toggleState(pos.r(), pos.c(), Board.WHITE);
			currentState = board.getState(pos.r(), pos.c());
		}
	}

	protected void rightDragged(Address pos) {
		if (isProblemEditMode()) {
			Square sq = board.getSquare(pos);
			if (sq != null)
				board.removeSquare(sq);
		} else {
			int st = board.getState(pos.r(), pos.c());
			if (st == currentState)
				return;
			if (currentState == Board.WHITE && st == Board.BLACK)
				return;
			board.changeStateA(pos.r(), pos.c(), currentState);
		}
	}
	
	private void resetPivot() {
		pivotR = -1;
		pivotC = -1;
	}

	/*
	 * uւ킯vL[
	 */
	protected void numberEntered(Address pos, int num) {
		if (isProblemEditMode()) {
			Square square = board.getSquare(pos.r(), pos.c());
			if (square != null)
				square.setNumber(num);
		}
	}
	
	protected void spaceEntered(Address pos) {
		if (isProblemEditMode()) {
			Square square = board.getSquare(pos.r(), pos.c());
			if (square != null)
				square.setNumber(Square.ANY);
		}
	}

	/**
	 * @param draggingSquare the draggingSquare to set
	 */
	void setDraggingSquare(Square draggingSquare) {
		((Panel) getPanel()).setDraggingSquare(draggingSquare);
	}

	/**
	 * @return the draggingSquare
	 */
	Square getDraggingSquare() {
		return ((Panel) getPanel()).getDraggingSquare();
	}
}

