/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Panel;
import pencilbox.heyawake.Square;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int pivotR = -1;
    private int pivotC = -1;
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected int getMaxInputNumber() {
        Address pos = this.getCellCursor().getPosition();
        Square square = this.board.getSquare(pos.r(), pos.c());
        if (square != null) {
            return square.mx();
        }
        return 0;
    }

    protected void leftPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Square sq = this.board.getSquare(pos);
            Square draggingSquare = sq == null ? new Square(pos.r(), pos.c(), pos.r(), pos.c()) : new Square(sq);
            this.fixPivot(draggingSquare, pos.r(), pos.c());
            this.setDraggingSquare(draggingSquare);
        } else {
            this.board.toggleState(pos.r(), pos.c(), 1);
            this.currentState = this.board.getState(pos.r(), pos.c());
        }
    }

    protected void leftDragged(Address pos) {
        if (this.isProblemEditMode()) {
            Square draggingSquare = this.getDraggingSquare();
            if (draggingSquare == null) {
                return;
            }
            if (this.pivotR >= 0 && this.pivotC >= 0) {
                draggingSquare.set(this.pivotR, this.pivotC, pos.r(), pos.c());
            } else if (this.pivotR >= 0 && this.pivotC == -1) {
                draggingSquare.set(this.pivotR, draggingSquare.c0(), pos.r(), draggingSquare.c1());
            } else if (this.pivotR == -1 && this.pivotC >= 0) {
                draggingSquare.set(draggingSquare.r0(), this.pivotC, draggingSquare.r1(), pos.c());
            } else if (this.pivotR == -1) {
                // empty if block
            }
            this.fixPivot(draggingSquare, pos.r(), pos.c());
        } else {
            int st = this.board.getState(pos.r(), pos.c());
            if (st == this.currentState) {
                return;
            }
            if (this.currentState == 1 && this.board.isBlock(pos.r(), pos.c())) {
                return;
            }
            this.board.changeStateA(pos.r(), pos.c(), this.currentState);
        }
    }

    private void fixPivot(Square s, int r, int c) {
        if (this.pivotR == -1) {
            if (r == s.r0()) {
                this.pivotR = s.r1();
            } else if (r == s.r1()) {
                this.pivotR = s.r0();
            }
        }
        if (this.pivotC == -1) {
            if (c == s.c0()) {
                this.pivotC = s.c1();
            } else if (c == s.c1()) {
                this.pivotC = s.c0();
            }
        }
    }

    protected void leftDragFixed(Address pos) {
        if (this.isProblemEditMode()) {
            int cp;
            Square draggingSquare = this.getDraggingSquare();
            if (draggingSquare == null) {
                return;
            }
            int rp = this.pivotR >= 0 ? this.pivotR : draggingSquare.r0();
            Square sq = this.board.getSquare(rp, cp = this.pivotC >= 0 ? this.pivotC : draggingSquare.c0());
            if (sq == null) {
                this.board.removeOverlappedSquares(draggingSquare, null);
                this.board.addSquare(new Square(draggingSquare));
            } else if (sq.r0() != draggingSquare.r0() || sq.c0() != draggingSquare.c0() || sq.r1() != draggingSquare.r1() || sq.c1() != draggingSquare.c1()) {
                this.board.removeOverlappedSquares(draggingSquare, sq);
                this.board.changeSquare(sq, draggingSquare);
            }
            this.setDraggingSquare(null);
            this.resetPivot();
        }
    }

    protected void dragFailed() {
        this.setDraggingSquare(null);
        this.resetPivot();
    }

    protected void rightPressed(Address pos) {
        if (this.isProblemEditMode()) {
            Square sq = this.board.getSquare(pos);
            if (sq != null) {
                this.board.removeSquare(sq);
            }
        } else {
            this.board.toggleState(pos.r(), pos.c(), 2);
            this.currentState = this.board.getState(pos.r(), pos.c());
        }
    }

    protected void rightDragged(Address pos) {
        if (this.isProblemEditMode()) {
            Square sq = this.board.getSquare(pos);
            if (sq != null) {
                this.board.removeSquare(sq);
            }
        } else {
            int st = this.board.getState(pos.r(), pos.c());
            if (st == this.currentState) {
                return;
            }
            if (this.currentState == 2 && st == 1) {
                return;
            }
            this.board.changeStateA(pos.r(), pos.c(), this.currentState);
        }
    }

    private void resetPivot() {
        this.pivotR = -1;
        this.pivotC = -1;
    }

    protected void numberEntered(Address pos, int num) {
        Square square;
        if (this.isProblemEditMode() && (square = this.board.getSquare(pos.r(), pos.c())) != null) {
            square.setNumber(num);
        }
    }

    protected void spaceEntered(Address pos) {
        Square square;
        if (this.isProblemEditMode() && (square = this.board.getSquare(pos.r(), pos.c())) != null) {
            square.setNumber(-1);
        }
    }

    void setDraggingSquare(Square draggingSquare) {
        ((Panel)this.getPanel()).setDraggingSquare(draggingSquare);
    }

    Square getDraggingSquare() {
        return ((Panel)this.getPanel()).getDraggingSquare();
    }
}

