/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.heyawake;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.Iterator;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.heyawake.Board;
import pencilbox.heyawake.Square;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private Color paintColor = Color.BLUE;
    private Color circleColor = Color.MAGENTA;
    private Color noAreaColor = new Color(0xC0C0C0);
    private Color areaBorderColor = Color.BLACK;
    private Color continuousRoomColor = new Color(0x800000);
    private Square draggingSquare;

    public Panel() {
        this.setMarkStyle(1);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawCells(g);
        this.drawBeams(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void paintAreas(Graphics2D g) {
        g.setColor(this.noAreaColor);
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.getSquare(r, c) == null) {
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawCells(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int st = this.board.getState(r, c);
                if (st == 1) {
                    g.setColor(this.getPaintColor());
                    if (this.isIndicateErrorMode() && (this.board.isBlock(r, c) || this.board.chain[r][c] == -1)) {
                        g.setColor(this.getErrorColor());
                    }
                    this.paintCell(g, r, c);
                } else if (st == 2) {
                    g.setColor(this.getCircleColor());
                    this.placeMark(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        Square square;
        g.setFont(this.getNumberFont());
        Iterator itr = this.board.getSquareListIterator();
        while (itr.hasNext()) {
            g.setColor(this.getAreaBorderColor());
            square = (Square)itr.next();
            this.placeSquare(g, square.r0(), square.c0(), square.r1(), square.c1());
            if (square.getNumber() < 0) continue;
            g.setColor(this.getNumberColor());
            if (this.isIndicateErrorMode() && square.getNumber() != square.getNBlack() && !this.board.isBlock(square.r0(), square.c0()) && this.board.chain[square.r0()][square.c0()] != -1) {
                g.setColor(this.getErrorColor());
            }
            this.placeNumber(g, square.r0(), square.c0(), square.getNumber());
        }
        square = this.getDraggingSquare();
        if (square != null) {
            g.setColor(this.areaBorderColor);
            this.placeSquare(g, square.r0(), square.c0(), square.r1(), square.c1());
        }
    }

    private void drawBeams(Graphics2D g) {
        if (this.isIndicateErrorMode()) {
            int r = 0;
            while (r < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    if (this.board.contH[r][c] >= 3) {
                        g.setColor(this.continuousRoomColor);
                        this.placeCenterLine(g, r, c, 1);
                    }
                    if (this.board.contV[r][c] >= 3) {
                        g.setColor(this.continuousRoomColor);
                        this.placeCenterLine(g, r, c, 0);
                    }
                    ++c;
                }
                ++r;
            }
        }
    }

    void setDraggingSquare(Square draggingSquare) {
        this.draggingSquare = draggingSquare;
    }

    Square getDraggingSquare() {
        return this.draggingSquare;
    }
}

