/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.hitori.Board;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;
    private int currentState = 0;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.setMaxInputNumber(this.board.getMaxNumber());
    }

    protected void leftPressed(Address pos) {
        this.board.toggleState(pos.r(), pos.c(), -2);
        this.currentState = this.board.getState(pos.r(), pos.c());
    }

    protected void rightPressed(Address pos) {
        this.board.toggleState(pos.r(), pos.c(), -1);
        this.currentState = this.board.getState(pos.r(), pos.c());
    }

    protected void leftDragged(Address pos) {
        int st = this.board.getState(pos.r(), pos.c());
        if (st == this.currentState) {
            return;
        }
        if (this.currentState == -2 && this.board.isBlock(pos.r(), pos.c())) {
            return;
        }
        this.board.changeStateA(pos.r(), pos.c(), this.currentState);
    }

    protected void rightDragged(Address pos) {
        int st = this.board.getState(pos.r(), pos.c());
        if (st == this.currentState) {
            return;
        }
        if (this.currentState == -1 && st == -2) {
            return;
        }
        this.board.changeStateA(pos.r(), pos.c(), this.currentState);
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            this.board.setNumber(pos.r(), pos.c(), num);
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            this.board.setNumber(pos.r(), pos.c(), 0);
        }
    }
}

