/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import pencilbox.kakuro.Board;
import pencilbox.kakuro.HintTbl;

public class DigitPatternHint {
    private Board board;
    private int[][] horizPattern;
    private int[][] vertPattern;

    int getPattern(int r, int c) {
        int pat = this.horizPattern[r][c] & this.vertPattern[r][c];
        if ((pat & 1) == 1) {
            return 1;
        }
        return pat;
    }

    void setupHint(Board board) {
        this.board = board;
        int rows = board.rows();
        int cols = board.cols();
        this.horizPattern = new int[rows][cols];
        this.vertPattern = new int[rows][cols];
    }

    void updatePattern(int r, int c) {
        this.updatePattern(r, c, 1);
        this.updatePattern(r, c, 0);
    }

    void updatePattern(int r, int c, int dir) {
        int i;
        int pattern = 0;
        int headPosition = this.board.getWordHead(r, c, dir);
        int wordSum = this.board.getWordSum(r, c, dir);
        int wordSize = this.board.getWordSize(r, c, dir);
        int currentSum = 0;
        int currentSize = 0;
        int usedDigit = 0;
        if (wordSum == 0) {
            pattern = 1023;
        } else if (wordSize > 9) {
            pattern = 0;
        } else {
            i = 0;
            while (i < wordSize) {
                int n = 0;
                if (dir == 1) {
                    n = this.board.getNumber(r, headPosition + 1 + i);
                } else if (dir == 0) {
                    n = this.board.getNumber(headPosition + 1 + i, c);
                }
                if (n > 0) {
                    ++currentSize;
                    currentSum += n;
                    usedDigit |= 1 << n;
                }
                ++i;
            }
            pattern = currentSize == wordSize ? 0 : HintTbl.getRemainingDigit(wordSum - currentSum, wordSize - currentSize, usedDigit);
        }
        i = 0;
        while (i < wordSize) {
            if (dir == 1) {
                this.horizPattern[r][headPosition + 1 + i] = pattern;
            } else if (dir == 0) {
                this.vertPattern[headPosition + 1 + i][c] = pattern;
            }
            ++i;
        }
    }

    void initHint() {
        int c;
        int r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                this.vertPattern[r][c] = 1023;
                this.horizPattern[r][c] = 1023;
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols()) {
                if (this.board.isWall(r, c)) {
                    if (!this.board.isWall(r, c + 1) && this.board.getSumH(r, c) > 0) {
                        this.updatePattern(r, c + 1, 1);
                    }
                    if (!this.board.isWall(r + 1, c) && this.board.getSumV(r, c) > 0) {
                        this.updatePattern(r + 1, c, 0);
                    }
                }
                ++c;
            }
            ++r;
        }
    }
}

