/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.lits;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.lits.Area;
import pencilbox.lits.Wall;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    public static final int WHITE = -1;
    public static final int BLACK = -2;
    public static final int UNKNOWN = 0;
    private List areaList;
    private Area[][] area;
    private int[][] state;
    private List wallList;
    private Wall[][] wall;
    private Wall initializingWall;

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList();
        this.wall = new Wall[this.rows()][this.cols()];
        this.wallList = new LinkedList();
    }

    public void clearBoard() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                this.state[r][c] = 0;
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.state[r][c] == -1) {
                    this.state[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public boolean isBlack(int r, int c) {
        return this.isOn(r, c) && this.state[r][c] == -2;
    }

    public Wall getWall(int r, int c) {
        return this.wall[r][c];
    }

    public void setWall(int r, int c, Wall a) {
        this.wall[r][c] = a;
    }

    public Area getArea(int r, int c) {
        if (!this.isOn(r, c)) {
            return null;
        }
        return this.area[r][c];
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void addArea(Area newArea) {
        Iterator itr = newArea.iterator();
        while (itr.hasNext()) {
            Address pos = (Address)itr.next();
            this.area[pos.r()][pos.c()] = newArea;
        }
        this.areaList.add(newArea);
    }

    public void removeArea(Area oldArea) {
        Iterator itr = oldArea.iterator();
        while (itr.hasNext()) {
            Address pos = (Address)itr.next();
            if (this.area[pos.r()][pos.c()] != oldArea) continue;
            this.area[pos.r()][pos.c()] = null;
        }
        this.areaList.remove(oldArea);
    }

    public void addCellToArea(Address pos, Area a) {
        if (a.isEmpty()) {
            this.areaList.add(a);
        }
        this.setArea(pos.r(), pos.c(), a);
        a.add(pos);
    }

    public void removeCellFromArea(Address pos, Area a) {
        this.setArea(pos.r(), pos.c(), null);
        a.remove(pos);
        if (a.isEmpty()) {
            this.areaList.remove(a);
        }
    }

    public void changeState(int r, int c, int st) {
        int prevSt = this.getState(r, c);
        this.setState(r, c, st);
        Area a = this.getArea(r, c);
        if (a != null) {
            if (prevSt == -2) {
                a.getTetromino().remove(r, c);
            }
            if (st == -2) {
                a.getTetromino().add(r, c);
            }
        }
    }

    public void changeStateA(int r, int c, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, this.state[r][c], st)));
        this.changeState(r, c, st);
    }

    public void toggleState(int r, int c, int st) {
        if (this.state[r][c] == st) {
            this.changeStateA(r, c, 0);
        } else {
            this.changeStateA(r, c, st);
        }
    }

    List getAreaList() {
        return this.areaList;
    }

    int[][] getState() {
        return this.state;
    }

    public void initBoard() {
        this.initTetrominos();
    }

    boolean is2x2Block(int r, int c) {
        if (this.isBlack(r, c)) {
            if (this.isBlack(r - 1, c)) {
                if (this.isBlack(r, c - 1) && this.isBlack(r - 1, c - 1)) {
                    return true;
                }
                if (this.isBlack(r, c + 1) && this.isBlack(r - 1, c + 1)) {
                    return true;
                }
            }
            if (this.isBlack(r + 1, c)) {
                if (this.isBlack(r, c - 1) && this.isBlack(r + 1, c - 1)) {
                    return true;
                }
                if (this.isBlack(r, c + 1) && this.isBlack(r + 1, c + 1)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int checkAnswerCode() {
        int result = 0;
        if (this.areaList.size() == 0) {
            result |= 1;
        }
        if (((result |= this.checkTetrominos()) & 8) == 0) {
            result |= this.checkAdjacentCongruousTetrominos();
        }
        result |= this.checkConnection();
        return result |= this.check2x2s();
    }

    public int checkTetrominos() {
        int result = 0;
        int[] count = new int[6];
        Iterator itr = this.areaList.iterator();
        while (itr.hasNext()) {
            Area a = (Area)itr.next();
            int n = a.getTetrominoType();
            count[n] = count[n] + 1;
        }
        if (count[0] > 0) {
            result = 8;
        }
        return result;
    }

    public void initTetrominos() {
        Iterator itr = this.areaList.iterator();
        while (itr.hasNext()) {
            ((Area)itr.next()).getTetromino().clear();
        }
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getArea(r, c) != null && this.getState(r, c) == -2) {
                    this.getArea(r, c).getTetromino().add(r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private int checkAdjacentCongruousTetrominos() {
        int result = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getArea(r, c) != null && this.getState(r, c) == -2) {
                    if (this.getArea(r, c + 1) != null && this.getArea(r, c) != this.getArea(r, c + 1) && this.getState(r, c + 1) == -2 && this.getArea(r, c).getTetrominoType() == this.getArea(r, c + 1).getTetrominoType()) {
                        result = 16;
                    }
                    if (this.getArea(r + 1, c) != null && this.getArea(r, c) != this.getArea(r + 1, c) && this.getState(r + 1, c) == -2 && this.getArea(r, c).getTetrominoType() == this.getArea(r + 1, c).getTetrominoType()) {
                        result = 16;
                    }
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    private int checkConnection() {
        ArrayUtil.initArrayObject2(this.wall, null);
        this.wallList.clear();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) == -2 && this.getWall(r, c) == null) {
                    if (this.wallList.size() > 0) {
                        return 32;
                    }
                    this.initWall(r, c);
                }
                ++c;
            }
            ++r;
        }
        return 0;
    }

    private void initWall(int r, int c) {
        this.initializingWall = new Wall();
        this.initializingWall.add(r, c);
        this.setWall(r, c, this.initializingWall);
        this.wallList.add(this.initializingWall);
        this.initWall1(r, c);
    }

    private void initWall1(int r, int c) {
        if (this.initWall2(r - 1, c)) {
            this.initWall1(r - 1, c);
        }
        if (this.initWall2(r, c - 1)) {
            this.initWall1(r, c - 1);
        }
        if (this.initWall2(r + 1, c)) {
            this.initWall1(r + 1, c);
        }
        if (this.initWall2(r, c + 1)) {
            this.initWall1(r, c + 1);
        }
    }

    private boolean initWall2(int r, int c) {
        if (!this.isBlack(r, c)) {
            return false;
        }
        if (this.getWall(r, c) == this.initializingWall) {
            return false;
        }
        this.initializingWall.add(r, c);
        this.setWall(r, c, this.initializingWall);
        return true;
    }

    private int check2x2s() {
        int result = 0;
        int r = this.rows() - 1;
        while (r >= 0) {
            int c = this.cols() - 1;
            while (c >= 0) {
                if (this.is2x2Block(r, c)) {
                    result |= 0x40;
                }
                --c;
            }
            --r;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u6b63\u89e3\u3067\u3059";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append("\u30d6\u30ed\u30c3\u30af\u304c\uff11\u3064\u3082\u306a\u3044\n");
        }
        if ((result & 2) == 2) {
            // empty if block
        }
        if ((result & 4) == 4) {
            // empty if block
        }
        if ((result & 8) == 8) {
            message.append("\u30c6\u30c8\u30ed\u30df\u30ce\u3092\u542b\u307e\u306a\u3044\u30d6\u30ed\u30c3\u30af\u304c\u3042\u308b\n");
        }
        if ((result & 0x10) == 16) {
            message.append("\u540c\u3058\u5f62\u306e\u30c6\u30c8\u30ed\u30df\u30ce\u304c\u96a3\u63a5\u3057\u3066\u3044\u308b\n");
        }
        if ((result & 0x20) == 32) {
            message.append("\u9ed2\u30de\u30b9\u304c\u3072\u3068\u3064\u306a\u304c\u308a\u306b\u306a\u3063\u3066\u3044\u306a\u3044\n");
        }
        if ((result & 0x40) == 64) {
            message.append("\u9ed2\u30de\u30b9\u304c\uff12\uff58\uff12\u30de\u30b9\u306e\u30ab\u30bf\u30de\u30ea\u306b\u306a\u3063\u3066\u3044\u308b\n");
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.row, this.col, this.after);
        }
    }
}

