/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.shikaku;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.shikaku.Square;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int UNDECIDED_NUMBER = -1;
    private int[][] number;
    private Square[][] square;
    private List squareList;

    protected void setup() {
        super.setup();
        this.number = new int[this.rows()][this.cols()];
        this.square = new Square[this.rows()][this.cols()];
        this.squareList = new LinkedList();
    }

    public void clearBoard() {
        super.clearBoard();
        this.squareList.clear();
        ArrayUtil.initArrayObject2(this.square, null);
    }

    int[][] getNumber() {
        return this.number;
    }

    public void initBoard() {
        this.initSquares();
    }

    public void initSquares() {
        Iterator itr = this.squareList.iterator();
        while (itr.hasNext()) {
            this.initSquare1((Square)itr.next());
        }
    }

    public void initSquare1(Square sq) {
        int n = 0;
        int r = sq.r0();
        while (r <= sq.r1()) {
            int c = sq.c0();
            while (c <= sq.c1()) {
                if (this.isNumber(r, c)) {
                    n = n != 0 ? -2 : this.number[r][c];
                }
                this.square[r][c] = sq;
                ++c;
            }
            ++r;
        }
        sq.setNumber(n);
    }

    public void clearSquare1(Square sq) {
        int r = sq.r0();
        while (r <= sq.r1()) {
            int c = sq.c0();
            while (c <= sq.c1()) {
                this.square[r][c] = null;
                ++c;
            }
            ++r;
        }
    }

    List getSquareList() {
        return this.squareList;
    }

    public int getNumber(int r, int c) {
        return this.number[r][c];
    }

    public void setNumber(int r, int c, int n) {
        this.number[r][c] = n;
    }

    public boolean isNumber(int r, int c) {
        return this.number[r][c] > 0 || this.number[r][c] == -1;
    }

    public Square getSquare(int r, int c) {
        return this.square[r][c];
    }

    public void setSquare(int r, int c, Square s) {
        this.square[r][c] = s;
    }

    public Square getSquare(Address pos) {
        return this.square[pos.r()][pos.c()];
    }

    public Iterator getSquareListIterator() {
        return this.squareList.iterator();
    }

    public int getSquareListSize() {
        return this.squareList.size();
    }

    public boolean isCovered(int r, int c) {
        return this.square[r][c] != null;
    }

    void removeOverlappedSquares(Square sq, Square org) {
        int r = sq.r0();
        while (r <= sq.r1()) {
            int c = sq.c0();
            while (c <= sq.c1()) {
                Square s = this.getSquare(r, c);
                if (s != null && s != org) {
                    this.removeSquareA(s);
                }
                ++c;
            }
            ++r;
        }
    }

    public void addSquareA(Square sq) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(sq.r0(), sq.c0(), sq.r1(), sq.c1(), 1)));
        this.addSquare(sq);
    }

    public void changeSquareA(Square sq, Square newSq) {
        int rOld = -1;
        int cOld = -1;
        int rNew = -1;
        int cNew = -1;
        if (sq.r0() == newSq.r0()) {
            rOld = sq.r1();
            rNew = newSq.r1();
        } else if (sq.r1() == newSq.r0()) {
            rOld = sq.r0();
            rNew = newSq.r1();
        } else if (sq.r0() == newSq.r1()) {
            rOld = sq.r1();
            rNew = newSq.r0();
        } else if (sq.r1() == newSq.r1()) {
            rOld = sq.r0();
            rNew = newSq.r0();
        }
        if (sq.c0() == newSq.c0()) {
            cOld = sq.c1();
            cNew = newSq.c1();
        } else if (sq.c1() == newSq.c0()) {
            cOld = sq.c0();
            cNew = newSq.c1();
        } else if (sq.c0() == newSq.c1()) {
            cOld = sq.c1();
            cNew = newSq.c0();
        } else if (sq.c1() == newSq.c1()) {
            cOld = sq.c0();
            cNew = newSq.c0();
        }
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(rOld, cOld, rNew, cNew, 2)));
        this.changeSquare(sq, newSq);
    }

    public void removeSquareA(Square sq) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(sq.r0(), sq.c0(), sq.r1(), sq.c1(), 0)));
        this.removeSquare(sq);
    }

    public void addSquare(Square sq) {
        this.initSquare1(sq);
        this.squareList.add(sq);
    }

    public void addSquare(int r0, int c0, int r1, int c1) {
        Square sq = new Square(r0, c0, r1, c1);
        this.addSquare(sq);
    }

    public void changeSquare(int rOld, int cOld, int rNew, int cNew) {
        Square sq = this.getSquare(rOld, cOld);
        this.clearSquare1(sq);
        sq.changeCorner(rOld, cOld, rNew, cNew);
        this.initSquare1(sq);
    }

    public void changeSquare(Square sq, Square newSq) {
        this.clearSquare1(sq);
        sq.set(newSq.r0(), newSq.c0(), newSq.r1(), newSq.c1());
        this.initSquare1(sq);
    }

    public void removeSquare(Square sq) {
        this.clearSquare1(sq);
        this.squareList.remove(sq);
    }

    public void removeSquare(int r0, int c0) {
        Square sq = this.getSquare(r0, c0);
        this.removeSquare(sq);
    }

    public int checkAnswerCode() {
        int errorCode = 0;
        int nNumber = 0;
        Iterator itr = this.squareList.iterator();
        while (itr.hasNext()) {
            Square sq = (Square)itr.next();
            int n = sq.getNumber();
            if (n == -2) {
                errorCode |= 1;
                continue;
            }
            if (n == 0) {
                errorCode |= 2;
                continue;
            }
            if (n == -1) continue;
            if (n < sq.getSquareSize()) {
                errorCode |= 4;
                continue;
            }
            if (n <= sq.getSquareSize()) continue;
            errorCode |= 8;
        }
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isNumber(r, c)) {
                    ++nNumber;
                }
                if (this.square[r][c] == null) {
                    errorCode |= 0x10;
                }
                ++c;
            }
            ++r;
        }
        if (nNumber == 0) {
            errorCode = 32;
        }
        return errorCode;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u6b63\u89e3\u3067\u3059";
        }
        if (result == 32) {
            return "\u76e4\u4e0a\u306b\u6570\u5b57\u304c\u3072\u3068\u3064\u3082\u306a\u3044\n";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append("\u8907\u6570\u306e\u6570\u5b57\u3092\u542b\u3080\u56db\u89d2\u304c\u3042\u308b\n");
        }
        if ((result & 2) == 2) {
            message.append("\u6570\u5b57\u3092\u542b\u307e\u306a\u3044\u56db\u89d2\u304c\u3042\u308b\n");
        }
        if ((result & 4) == 4) {
            message.append("\u9762\u7a4d\u304c\u6570\u5b57\u3092\u8d85\u3048\u308b\u56db\u89d2\u304c\u3042\u308b\n");
        }
        if ((result & 8) == 8) {
            message.append("\u9762\u7a4d\u304c\u6570\u5b57\u306b\u6e80\u305f\u306a\u3044\u56db\u89d2\u304c\u3042\u308b\n");
        }
        if ((result & 0x10) == 16) {
            message.append("\u56db\u89d2\u306b\u542b\u307e\u308c\u306a\u3044\u30de\u30b9\u304c\u3042\u308b\n");
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        static final int ADDED = 1;
        static final int REMOVED = 0;
        static final int CHANGED = 2;
        private int r0;
        private int c0;
        private int r1;
        private int c1;
        private int operation;

        public Step(int r0, int c0, int r1, int c1, int operation) {
            this.r0 = r0;
            this.c0 = c0;
            this.r1 = r1;
            this.c1 = c1;
            this.operation = operation;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.operation == 1) {
                Board.this.removeSquare(this.r0, this.c0);
            } else if (this.operation == 0) {
                Board.this.addSquare(this.r0, this.c0, this.r1, this.c1);
            } else if (this.operation == 2) {
                Board.this.changeSquare(this.r1, this.c1, this.r0, this.c0);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.operation == 1) {
                Board.this.addSquare(this.r0, this.c0, this.r1, this.c1);
            } else if (this.operation == 0) {
                Board.this.removeSquare(this.r0, this.c0);
            } else if (this.operation == 2) {
                Board.this.changeSquare(this.r0, this.c0, this.r1, this.c1);
            }
        }
    }
}

